package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomTLSProfileBuilder extends CustomTLSProfileFluent<CustomTLSProfileBuilder> implements VisitableBuilder<CustomTLSProfile,CustomTLSProfileBuilder>{
  public CustomTLSProfileBuilder() {
    this(false);
  }
  public CustomTLSProfileBuilder(Boolean validationEnabled) {
    this(new CustomTLSProfile(), validationEnabled);
  }
  public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomTLSProfile(), validationEnabled);
  }
  public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,CustomTLSProfile instance) {
    this(fluent, instance, false);
  }
  public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent,CustomTLSProfile instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CustomTLSProfile());

    if (instance != null) {
      fluent.withCiphers(instance.getCiphers());
      fluent.withMinTLSVersion(instance.getMinTLSVersion());
      fluent.withCiphers(instance.getCiphers());
      fluent.withMinTLSVersion(instance.getMinTLSVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CustomTLSProfileBuilder(CustomTLSProfile instance) {
    this(instance,false);
  }
  public CustomTLSProfileBuilder(CustomTLSProfile instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CustomTLSProfile());

    if (instance != null) {
      this.withCiphers(instance.getCiphers());
      this.withMinTLSVersion(instance.getMinTLSVersion());
      this.withCiphers(instance.getCiphers());
      this.withMinTLSVersion(instance.getMinTLSVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CustomTLSProfileFluent<?> fluent;
  Boolean validationEnabled;
  public CustomTLSProfile build() {
    CustomTLSProfile buildable = new CustomTLSProfile(fluent.getCiphers(),fluent.getMinTLSVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}