package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSPlatformSpecBuilder extends DNSPlatformSpecFluent<DNSPlatformSpecBuilder> implements VisitableBuilder<DNSPlatformSpec,DNSPlatformSpecBuilder>{
  public DNSPlatformSpecBuilder() {
    this(false);
  }
  public DNSPlatformSpecBuilder(Boolean validationEnabled) {
    this(new DNSPlatformSpec(), validationEnabled);
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSPlatformSpec(), validationEnabled);
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpecFluent<?> fluent,DNSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpecFluent<?> fluent,DNSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSPlatformSpec());

    if (instance != null) {
      fluent.withAws(instance.getAws());
      fluent.withType(instance.getType());
      fluent.withAws(instance.getAws());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpec instance) {
    this(instance,false);
  }
  public DNSPlatformSpecBuilder(DNSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSPlatformSpec());

    if (instance != null) {
      this.withAws(instance.getAws());
      this.withType(instance.getType());
      this.withAws(instance.getAws());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DNSPlatformSpec build() {
    DNSPlatformSpec buildable = new DNSPlatformSpec(fluent.buildAws(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}