package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSSpecBuilder extends DNSSpecFluent<DNSSpecBuilder> implements VisitableBuilder<DNSSpec,DNSSpecBuilder>{
  public DNSSpecBuilder() {
    this(false);
  }
  public DNSSpecBuilder(Boolean validationEnabled) {
    this(new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DNSSpec(), validationEnabled);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance) {
    this(fluent, instance, false);
  }
  public DNSSpecBuilder(DNSSpecFluent<?> fluent,DNSSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DNSSpec());

    if (instance != null) {
      fluent.withBaseDomain(instance.getBaseDomain());
      fluent.withPlatform(instance.getPlatform());
      fluent.withPrivateZone(instance.getPrivateZone());
      fluent.withPublicZone(instance.getPublicZone());
      fluent.withBaseDomain(instance.getBaseDomain());
      fluent.withPlatform(instance.getPlatform());
      fluent.withPrivateZone(instance.getPrivateZone());
      fluent.withPublicZone(instance.getPublicZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DNSSpecBuilder(DNSSpec instance) {
    this(instance,false);
  }
  public DNSSpecBuilder(DNSSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DNSSpec());

    if (instance != null) {
      this.withBaseDomain(instance.getBaseDomain());
      this.withPlatform(instance.getPlatform());
      this.withPrivateZone(instance.getPrivateZone());
      this.withPublicZone(instance.getPublicZone());
      this.withBaseDomain(instance.getBaseDomain());
      this.withPlatform(instance.getPlatform());
      this.withPrivateZone(instance.getPrivateZone());
      this.withPublicZone(instance.getPublicZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DNSSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DNSSpec build() {
    DNSSpec buildable = new DNSSpec(fluent.getBaseDomain(),fluent.buildPlatform(),fluent.buildPrivateZone(),fluent.buildPublicZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}