package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateStatusBuilder extends FeatureGateStatusFluent<FeatureGateStatusBuilder> implements VisitableBuilder<FeatureGateStatus,FeatureGateStatusBuilder>{
  public FeatureGateStatusBuilder() {
    this(false);
  }
  public FeatureGateStatusBuilder(Boolean validationEnabled) {
    this(new FeatureGateStatus(), validationEnabled);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FeatureGateStatus(), validationEnabled);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance) {
    this(fluent, instance, false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatusFluent<?> fluent,FeatureGateStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FeatureGateStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withFeatureGates(instance.getFeatureGates());
      fluent.withConditions(instance.getConditions());
      fluent.withFeatureGates(instance.getFeatureGates());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateStatusBuilder(FeatureGateStatus instance) {
    this(instance,false);
  }
  public FeatureGateStatusBuilder(FeatureGateStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FeatureGateStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withFeatureGates(instance.getFeatureGates());
      this.withConditions(instance.getConditions());
      this.withFeatureGates(instance.getFeatureGates());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FeatureGateStatusFluent<?> fluent;
  Boolean validationEnabled;
  public FeatureGateStatus build() {
    FeatureGateStatus buildable = new FeatureGateStatus(fluent.getConditions(),fluent.buildFeatureGates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}