package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageContentPolicySpecBuilder extends ImageContentPolicySpecFluent<ImageContentPolicySpecBuilder> implements VisitableBuilder<ImageContentPolicySpec,ImageContentPolicySpecBuilder>{
  public ImageContentPolicySpecBuilder() {
    this(false);
  }
  public ImageContentPolicySpecBuilder(Boolean validationEnabled) {
    this(new ImageContentPolicySpec(), validationEnabled);
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ImageContentPolicySpec(), validationEnabled);
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpecFluent<?> fluent,ImageContentPolicySpec instance) {
    this(fluent, instance, false);
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpecFluent<?> fluent,ImageContentPolicySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ImageContentPolicySpec());

    if (instance != null) {
      fluent.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors());
      fluent.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpec instance) {
    this(instance,false);
  }
  public ImageContentPolicySpecBuilder(ImageContentPolicySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ImageContentPolicySpec());

    if (instance != null) {
      this.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors());
      this.withRepositoryDigestMirrors(instance.getRepositoryDigestMirrors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ImageContentPolicySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ImageContentPolicySpec build() {
    ImageContentPolicySpec buildable = new ImageContentPolicySpec(fluent.buildRepositoryDigestMirrors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}