package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureStatusBuilder extends InfrastructureStatusFluent<InfrastructureStatusBuilder> implements VisitableBuilder<InfrastructureStatus,InfrastructureStatusBuilder>{
  public InfrastructureStatusBuilder() {
    this(false);
  }
  public InfrastructureStatusBuilder(Boolean validationEnabled) {
    this(new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InfrastructureStatus(), validationEnabled);
  }
  public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent,InfrastructureStatus instance) {
    this(fluent, instance, false);
  }
  public InfrastructureStatusBuilder(InfrastructureStatusFluent<?> fluent,InfrastructureStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InfrastructureStatus());

    if (instance != null) {
      fluent.withApiServerInternalURI(instance.getApiServerInternalURI());
      fluent.withApiServerURL(instance.getApiServerURL());
      fluent.withControlPlaneTopology(instance.getControlPlaneTopology());
      fluent.withCpuPartitioning(instance.getCpuPartitioning());
      fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      fluent.withInfrastructureName(instance.getInfrastructureName());
      fluent.withInfrastructureTopology(instance.getInfrastructureTopology());
      fluent.withPlatform(instance.getPlatform());
      fluent.withPlatformStatus(instance.getPlatformStatus());
      fluent.withApiServerInternalURI(instance.getApiServerInternalURI());
      fluent.withApiServerURL(instance.getApiServerURL());
      fluent.withControlPlaneTopology(instance.getControlPlaneTopology());
      fluent.withCpuPartitioning(instance.getCpuPartitioning());
      fluent.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      fluent.withInfrastructureName(instance.getInfrastructureName());
      fluent.withInfrastructureTopology(instance.getInfrastructureTopology());
      fluent.withPlatform(instance.getPlatform());
      fluent.withPlatformStatus(instance.getPlatformStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureStatusBuilder(InfrastructureStatus instance) {
    this(instance,false);
  }
  public InfrastructureStatusBuilder(InfrastructureStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InfrastructureStatus());

    if (instance != null) {
      this.withApiServerInternalURI(instance.getApiServerInternalURI());
      this.withApiServerURL(instance.getApiServerURL());
      this.withControlPlaneTopology(instance.getControlPlaneTopology());
      this.withCpuPartitioning(instance.getCpuPartitioning());
      this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      this.withInfrastructureName(instance.getInfrastructureName());
      this.withInfrastructureTopology(instance.getInfrastructureTopology());
      this.withPlatform(instance.getPlatform());
      this.withPlatformStatus(instance.getPlatformStatus());
      this.withApiServerInternalURI(instance.getApiServerInternalURI());
      this.withApiServerURL(instance.getApiServerURL());
      this.withControlPlaneTopology(instance.getControlPlaneTopology());
      this.withCpuPartitioning(instance.getCpuPartitioning());
      this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
      this.withInfrastructureName(instance.getInfrastructureName());
      this.withInfrastructureTopology(instance.getInfrastructureTopology());
      this.withPlatform(instance.getPlatform());
      this.withPlatformStatus(instance.getPlatformStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InfrastructureStatusFluent<?> fluent;
  Boolean validationEnabled;
  public InfrastructureStatus build() {
    InfrastructureStatus buildable = new InfrastructureStatus(fluent.getApiServerInternalURI(),fluent.getApiServerURL(),fluent.getControlPlaneTopology(),fluent.getCpuPartitioning(),fluent.getEtcdDiscoveryDomain(),fluent.getInfrastructureName(),fluent.getInfrastructureTopology(),fluent.getPlatform(),fluent.buildPlatformStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}