package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressStatusBuilder extends IngressStatusFluent<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(false);
  }
  public IngressStatusBuilder(Boolean validationEnabled) {
    this(new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance) {
    this(fluent, instance, false);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressStatus());

    if (instance != null) {
      fluent.withComponentRoutes(instance.getComponentRoutes());
      fluent.withDefaultPlacement(instance.getDefaultPlacement());
      fluent.withComponentRoutes(instance.getComponentRoutes());
      fluent.withDefaultPlacement(instance.getDefaultPlacement());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressStatusBuilder(IngressStatus instance) {
    this(instance,false);
  }
  public IngressStatusBuilder(IngressStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressStatus());

    if (instance != null) {
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDefaultPlacement(instance.getDefaultPlacement());
      this.withComponentRoutes(instance.getComponentRoutes());
      this.withDefaultPlacement(instance.getDefaultPlacement());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.buildComponentRoutes(),fluent.getDefaultPlacement());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}