package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LDAPIdentityProviderBuilder extends LDAPIdentityProviderFluent<LDAPIdentityProviderBuilder> implements VisitableBuilder<LDAPIdentityProvider,LDAPIdentityProviderBuilder>{
  public LDAPIdentityProviderBuilder() {
    this(false);
  }
  public LDAPIdentityProviderBuilder(Boolean validationEnabled) {
    this(new LDAPIdentityProvider(), validationEnabled);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LDAPIdentityProvider(), validationEnabled);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProviderFluent<?> fluent,LDAPIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LDAPIdentityProvider());

    if (instance != null) {
      fluent.withAttributes(instance.getAttributes());
      fluent.withBindDN(instance.getBindDN());
      fluent.withBindPassword(instance.getBindPassword());
      fluent.withCa(instance.getCa());
      fluent.withInsecure(instance.getInsecure());
      fluent.withUrl(instance.getUrl());
      fluent.withAttributes(instance.getAttributes());
      fluent.withBindDN(instance.getBindDN());
      fluent.withBindPassword(instance.getBindPassword());
      fluent.withCa(instance.getCa());
      fluent.withInsecure(instance.getInsecure());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance) {
    this(instance,false);
  }
  public LDAPIdentityProviderBuilder(LDAPIdentityProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LDAPIdentityProvider());

    if (instance != null) {
      this.withAttributes(instance.getAttributes());
      this.withBindDN(instance.getBindDN());
      this.withBindPassword(instance.getBindPassword());
      this.withCa(instance.getCa());
      this.withInsecure(instance.getInsecure());
      this.withUrl(instance.getUrl());
      this.withAttributes(instance.getAttributes());
      this.withBindDN(instance.getBindDN());
      this.withBindPassword(instance.getBindPassword());
      this.withCa(instance.getCa());
      this.withInsecure(instance.getInsecure());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LDAPIdentityProviderFluent<?> fluent;
  Boolean validationEnabled;
  public LDAPIdentityProvider build() {
    LDAPIdentityProvider buildable = new LDAPIdentityProvider(fluent.buildAttributes(),fluent.getBindDN(),fluent.buildBindPassword(),fluent.buildCa(),fluent.getInsecure(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}