package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkBuilder extends NetworkFluent<NetworkBuilder> implements VisitableBuilder<Network,NetworkBuilder>{
  public NetworkBuilder() {
    this(false);
  }
  public NetworkBuilder(Boolean validationEnabled) {
    this(new Network(), validationEnabled);
  }
  public NetworkBuilder(NetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Network(), validationEnabled);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Network instance) {
    this(fluent, instance, false);
  }
  public NetworkBuilder(NetworkFluent<?> fluent,Network instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Network());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkBuilder(Network instance) {
    this(instance,false);
  }
  public NetworkBuilder(Network instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Network());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkFluent<?> fluent;
  Boolean validationEnabled;
  public Network build() {
    Network buildable = new Network(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}