package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthStatusBuilder extends OAuthStatusFluent<OAuthStatusBuilder> implements VisitableBuilder<OAuthStatus,OAuthStatusBuilder>{
  public OAuthStatusBuilder() {
    this(false);
  }
  public OAuthStatusBuilder(Boolean validationEnabled) {
    this(new OAuthStatus(), validationEnabled);
  }
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OAuthStatus(), validationEnabled);
  }
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,OAuthStatus instance) {
    this(fluent, instance, false);
  }
  public OAuthStatusBuilder(OAuthStatusFluent<?> fluent,OAuthStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OAuthStatus());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OAuthStatusBuilder(OAuthStatus instance) {
    this(instance,false);
  }
  public OAuthStatusBuilder(OAuthStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OAuthStatus());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OAuthStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OAuthStatus build() {
    OAuthStatus buildable = new OAuthStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}