package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenStackPlatformLoadBalancerBuilder extends OpenStackPlatformLoadBalancerFluent<OpenStackPlatformLoadBalancerBuilder> implements VisitableBuilder<OpenStackPlatformLoadBalancer,OpenStackPlatformLoadBalancerBuilder>{
  public OpenStackPlatformLoadBalancerBuilder() {
    this(false);
  }
  public OpenStackPlatformLoadBalancerBuilder(Boolean validationEnabled) {
    this(new OpenStackPlatformLoadBalancer(), validationEnabled);
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancerFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OpenStackPlatformLoadBalancer(), validationEnabled);
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancerFluent<?> fluent,OpenStackPlatformLoadBalancer instance) {
    this(fluent, instance, false);
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancerFluent<?> fluent,OpenStackPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OpenStackPlatformLoadBalancer());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancer instance) {
    this(instance,false);
  }
  public OpenStackPlatformLoadBalancerBuilder(OpenStackPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OpenStackPlatformLoadBalancer());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OpenStackPlatformLoadBalancerFluent<?> fluent;
  Boolean validationEnabled;
  public OpenStackPlatformLoadBalancer build() {
    OpenStackPlatformLoadBalancer buildable = new OpenStackPlatformLoadBalancer(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}