package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OvirtPlatformLoadBalancerBuilder extends OvirtPlatformLoadBalancerFluent<OvirtPlatformLoadBalancerBuilder> implements VisitableBuilder<OvirtPlatformLoadBalancer,OvirtPlatformLoadBalancerBuilder>{
  public OvirtPlatformLoadBalancerBuilder() {
    this(false);
  }
  public OvirtPlatformLoadBalancerBuilder(Boolean validationEnabled) {
    this(new OvirtPlatformLoadBalancer(), validationEnabled);
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancerFluent<?> fluent) {
    this(fluent, false);
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OvirtPlatformLoadBalancer(), validationEnabled);
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancerFluent<?> fluent,OvirtPlatformLoadBalancer instance) {
    this(fluent, instance, false);
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancerFluent<?> fluent,OvirtPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OvirtPlatformLoadBalancer());

    if (instance != null) {
      fluent.withType(instance.getType());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancer instance) {
    this(instance,false);
  }
  public OvirtPlatformLoadBalancerBuilder(OvirtPlatformLoadBalancer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OvirtPlatformLoadBalancer());

    if (instance != null) {
      this.withType(instance.getType());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OvirtPlatformLoadBalancerFluent<?> fluent;
  Boolean validationEnabled;
  public OvirtPlatformLoadBalancer build() {
    OvirtPlatformLoadBalancer buildable = new OvirtPlatformLoadBalancer(fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}