package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSPlatformSpecBuilder extends PowerVSPlatformSpecFluent<PowerVSPlatformSpecBuilder> implements VisitableBuilder<PowerVSPlatformSpec,PowerVSPlatformSpecBuilder>{
  public PowerVSPlatformSpecBuilder() {
    this(false);
  }
  public PowerVSPlatformSpecBuilder(Boolean validationEnabled) {
    this(new PowerVSPlatformSpec(), validationEnabled);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PowerVSPlatformSpec(), validationEnabled);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,PowerVSPlatformSpec instance) {
    this(fluent, instance, false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpecFluent<?> fluent,PowerVSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PowerVSPlatformSpec());

    if (instance != null) {
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withServiceEndpoints(instance.getServiceEndpoints());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance) {
    this(instance,false);
  }
  public PowerVSPlatformSpecBuilder(PowerVSPlatformSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PowerVSPlatformSpec());

    if (instance != null) {
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withServiceEndpoints(instance.getServiceEndpoints());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PowerVSPlatformSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PowerVSPlatformSpec build() {
    PowerVSPlatformSpec buildable = new PowerVSPlatformSpec(fluent.buildServiceEndpoints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}