package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSServiceEndpointBuilder extends PowerVSServiceEndpointFluent<PowerVSServiceEndpointBuilder> implements VisitableBuilder<PowerVSServiceEndpoint,PowerVSServiceEndpointBuilder>{
  public PowerVSServiceEndpointBuilder() {
    this(false);
  }
  public PowerVSServiceEndpointBuilder(Boolean validationEnabled) {
    this(new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpointFluent<?> fluent,PowerVSServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpointFluent<?> fluent,PowerVSServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new PowerVSServiceEndpoint());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withName(instance.getName());
      fluent.withUrl(instance.getUrl());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpoint instance) {
    this(instance,false);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new PowerVSServiceEndpoint());

    if (instance != null) {
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withName(instance.getName());
      this.withUrl(instance.getUrl());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PowerVSServiceEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public PowerVSServiceEndpoint build() {
    PowerVSServiceEndpoint buildable = new PowerVSServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}