package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyListBuilder extends ProxyListFluent<ProxyListBuilder> implements VisitableBuilder<ProxyList,ProxyListBuilder>{
  public ProxyListBuilder() {
    this(false);
  }
  public ProxyListBuilder(Boolean validationEnabled) {
    this(new ProxyList(), validationEnabled);
  }
  public ProxyListBuilder(ProxyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyListBuilder(ProxyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProxyList(), validationEnabled);
  }
  public ProxyListBuilder(ProxyListFluent<?> fluent,ProxyList instance) {
    this(fluent, instance, false);
  }
  public ProxyListBuilder(ProxyListFluent<?> fluent,ProxyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProxyList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxyListBuilder(ProxyList instance) {
    this(instance,false);
  }
  public ProxyListBuilder(ProxyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProxyList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxyListFluent<?> fluent;
  Boolean validationEnabled;
  public ProxyList build() {
    ProxyList buildable = new ProxyList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}