package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxySpecBuilder extends ProxySpecFluent<ProxySpecBuilder> implements VisitableBuilder<ProxySpec,ProxySpecBuilder>{
  public ProxySpecBuilder() {
    this(false);
  }
  public ProxySpecBuilder(Boolean validationEnabled) {
    this(new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(ProxySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxySpecBuilder(ProxySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(ProxySpecFluent<?> fluent,ProxySpec instance) {
    this(fluent, instance, false);
  }
  public ProxySpecBuilder(ProxySpecFluent<?> fluent,ProxySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProxySpec());

    if (instance != null) {
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withReadinessEndpoints(instance.getReadinessEndpoints());
      fluent.withTrustedCA(instance.getTrustedCA());
      fluent.withHttpProxy(instance.getHttpProxy());
      fluent.withHttpsProxy(instance.getHttpsProxy());
      fluent.withNoProxy(instance.getNoProxy());
      fluent.withReadinessEndpoints(instance.getReadinessEndpoints());
      fluent.withTrustedCA(instance.getTrustedCA());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProxySpecBuilder(ProxySpec instance) {
    this(instance,false);
  }
  public ProxySpecBuilder(ProxySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProxySpec());

    if (instance != null) {
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withReadinessEndpoints(instance.getReadinessEndpoints());
      this.withTrustedCA(instance.getTrustedCA());
      this.withHttpProxy(instance.getHttpProxy());
      this.withHttpsProxy(instance.getHttpsProxy());
      this.withNoProxy(instance.getNoProxy());
      this.withReadinessEndpoints(instance.getReadinessEndpoints());
      this.withTrustedCA(instance.getTrustedCA());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProxySpecFluent<?> fluent;
  Boolean validationEnabled;
  public ProxySpec build() {
    ProxySpec buildable = new ProxySpec(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getReadinessEndpoints(),fluent.buildTrustedCA());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}