package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpdateBuilder extends UpdateFluent<UpdateBuilder> implements VisitableBuilder<Update,UpdateBuilder>{
  public UpdateBuilder() {
    this(false);
  }
  public UpdateBuilder(Boolean validationEnabled) {
    this(new Update(), validationEnabled);
  }
  public UpdateBuilder(UpdateFluent<?> fluent) {
    this(fluent, false);
  }
  public UpdateBuilder(UpdateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Update(), validationEnabled);
  }
  public UpdateBuilder(UpdateFluent<?> fluent,Update instance) {
    this(fluent, instance, false);
  }
  public UpdateBuilder(UpdateFluent<?> fluent,Update instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Update());

    if (instance != null) {
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withForce(instance.getForce());
      fluent.withImage(instance.getImage());
      fluent.withVersion(instance.getVersion());
      fluent.withArchitecture(instance.getArchitecture());
      fluent.withForce(instance.getForce());
      fluent.withImage(instance.getImage());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public UpdateBuilder(Update instance) {
    this(instance,false);
  }
  public UpdateBuilder(Update instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Update());

    if (instance != null) {
      this.withArchitecture(instance.getArchitecture());
      this.withForce(instance.getForce());
      this.withImage(instance.getImage());
      this.withVersion(instance.getVersion());
      this.withArchitecture(instance.getArchitecture());
      this.withForce(instance.getForce());
      this.withImage(instance.getImage());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  UpdateFluent<?> fluent;
  Boolean validationEnabled;
  public Update build() {
    Update buildable = new Update(fluent.getArchitecture(),fluent.getForce(),fluent.getImage(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}