package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PowerVSPlatformSpecFluent<A extends PowerVSPlatformSpecFluent<A>> extends BaseFluent<A>{
  public PowerVSPlatformSpecFluent() {
  }
  
  public PowerVSPlatformSpecFluent(PowerVSPlatformSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PowerVSServiceEndpointBuilder> serviceEndpoints = new ArrayList<PowerVSServiceEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PowerVSPlatformSpec instance) {
    instance = (instance != null ? instance : new PowerVSPlatformSpec());
  
    if (instance != null) {
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToServiceEndpoints(int index,PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpointBuilder>();}
    PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").add(index, builder); serviceEndpoints.add(index, builder);}
    return (A)this;
  }
  
  public A setToServiceEndpoints(int index,PowerVSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpointBuilder>();}
    PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder); serviceEndpoints.set(index, builder);}
    return (A)this;
  }
  
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpointBuilder>();}
    for (PowerVSServiceEndpoint item : items) {PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A addAllToServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<PowerVSServiceEndpointBuilder>();}
    for (PowerVSServiceEndpoint item : items) {PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (PowerVSServiceEndpoint item : items) {PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServiceEndpoints(Collection<PowerVSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (PowerVSServiceEndpoint item : items) {PowerVSServiceEndpointBuilder builder = new PowerVSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServiceEndpoints(Predicate<PowerVSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<PowerVSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      PowerVSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PowerVSServiceEndpoint> buildServiceEndpoints() {
    return serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  
  public PowerVSServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  
  public PowerVSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  
  public PowerVSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  
  public PowerVSServiceEndpoint buildMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
    for (PowerVSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
    for (PowerVSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withServiceEndpoints(List<PowerVSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").clear();}
    if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList(); for (PowerVSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
  }
  
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.PowerVSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear(); _visitables.remove("serviceEndpoints"); }
    if (serviceEndpoints != null) {for (PowerVSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  
  public boolean hasServiceEndpoints() {
    return serviceEndpoints != null && !serviceEndpoints.isEmpty();
  }
  
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new PowerVSServiceEndpoint(name, url));
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new ServiceEndpointsNested(-1, null);
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpointLike(PowerVSServiceEndpoint item) {
    return new ServiceEndpointsNested(-1, item);
  }
  
  public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,PowerVSServiceEndpoint item) {
    return new ServiceEndpointsNested(index, item);
  }
  
  public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  
  public ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<PowerVSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PowerVSPlatformSpecFluent that = (PowerVSPlatformSpecFluent) o;
    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (serviceEndpoints != null && !serviceEndpoints.isEmpty()) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ServiceEndpointsNested<N> extends PowerVSServiceEndpointFluent<ServiceEndpointsNested<N>> implements Nested<N>{
    ServiceEndpointsNested(int index,PowerVSServiceEndpoint item) {
      this.index = index;
      this.builder = new PowerVSServiceEndpointBuilder(this, item);
    }
    PowerVSServiceEndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) PowerVSPlatformSpecFluent.this.setToServiceEndpoints(index,builder.build());
    }
    
    public N endServiceEndpoint() {
      return and();
    }
    
  
  }

}