package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AWSPlatformStatusFluent<A extends AWSPlatformStatusFluent<A>> extends BaseFluent<A>{
  public AWSPlatformStatusFluent() {
  }
  
  public AWSPlatformStatusFluent(AWSPlatformStatus instance) {
    this.copyInstance(instance);
  }
  private String region;
  private ArrayList<AWSResourceTagBuilder> resourceTags = new ArrayList<AWSResourceTagBuilder>();
  private ArrayList<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AWSPlatformStatus instance) {
    instance = (instance != null ? instance : new AWSPlatformStatus());
    if (instance != null) {
          this.withRegion(instance.getRegion());
          this.withResourceTags(instance.getResourceTags());
          this.withServiceEndpoints(instance.getServiceEndpoints());
          this.withRegion(instance.getRegion());
          this.withResourceTags(instance.getResourceTags());
          this.withServiceEndpoints(instance.getServiceEndpoints());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToResourceTags(int index,AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").add(index, builder); resourceTags.add(index, builder);}
    return (A)this;
  }
  
  public A setToResourceTags(int index,AWSResourceTag item) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= resourceTags.size()) { _visitables.get("resourceTags").add(builder); resourceTags.add(builder); } else { _visitables.get("resourceTags").set(index, builder); resourceTags.set(index, builder);}
    return (A)this;
  }
  
  public A addToResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A addAllToResourceTags(Collection<AWSResourceTag> items) {
    if (this.resourceTags == null) {this.resourceTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").add(builder);this.resourceTags.add(builder);} return (A)this;
  }
  
  public A removeFromResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... items) {
    if (this.resourceTags == null) return (A)this;
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceTags(Collection<AWSResourceTag> items) {
    if (this.resourceTags == null) return (A)this;
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("resourceTags").remove(builder); this.resourceTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceTags(Predicate<AWSResourceTagBuilder> predicate) {
    if (resourceTags == null) return (A) this;
    final Iterator<AWSResourceTagBuilder> each = resourceTags.iterator();
    final List visitables = _visitables.get("resourceTags");
    while (each.hasNext()) {
      AWSResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AWSResourceTag> buildResourceTags() {
    return this.resourceTags != null ? build(resourceTags) : null;
  }
  
  public AWSResourceTag buildResourceTag(int index) {
    return this.resourceTags.get(index).build();
  }
  
  public AWSResourceTag buildFirstResourceTag() {
    return this.resourceTags.get(0).build();
  }
  
  public AWSResourceTag buildLastResourceTag() {
    return this.resourceTags.get(resourceTags.size() - 1).build();
  }
  
  public AWSResourceTag buildMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
      for (AWSResourceTagBuilder item : resourceTags) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
      for (AWSResourceTagBuilder item : resourceTags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceTags(List<AWSResourceTag> resourceTags) {
    if (this.resourceTags != null) {
      this._visitables.get("resourceTags").clear();
    }
    if (resourceTags != null) {
        this.resourceTags = new ArrayList();
        for (AWSResourceTag item : resourceTags) {
          this.addToResourceTags(item);
        }
    } else {
      this.resourceTags = null;
    }
    return (A) this;
  }
  
  public A withResourceTags(io.fabric8.openshift.api.model.config.v1.AWSResourceTag... resourceTags) {
    if (this.resourceTags != null) {this.resourceTags.clear(); _visitables.remove("resourceTags"); }
    if (resourceTags != null) {for (AWSResourceTag item :resourceTags){ this.addToResourceTags(item);}} return (A) this;
  }
  
  public boolean hasResourceTags() {
    return this.resourceTags != null && !this.resourceTags.isEmpty();
  }
  
  public A addNewResourceTag(String key,String value) {
    return (A)addToResourceTags(new AWSResourceTag(key, value));
  }
  
  public ResourceTagsNested<A> addNewResourceTag() {
    return new ResourceTagsNested(-1, null);
  }
  
  public ResourceTagsNested<A> addNewResourceTagLike(AWSResourceTag item) {
    return new ResourceTagsNested(-1, item);
  }
  
  public ResourceTagsNested<A> setNewResourceTagLike(int index,AWSResourceTag item) {
    return new ResourceTagsNested(index, item);
  }
  
  public ResourceTagsNested<A> editResourceTag(int index) {
    if (resourceTags.size() <= index) throw new RuntimeException("Can't edit resourceTags. Index exceeds size.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editFirstResourceTag() {
    if (resourceTags.size() == 0) throw new RuntimeException("Can't edit first resourceTags. The list is empty.");
    return setNewResourceTagLike(0, buildResourceTag(0));
  }
  
  public ResourceTagsNested<A> editLastResourceTag() {
    int index = resourceTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceTags. The list is empty.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AWSResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceTags.size();i++) { 
    if (predicate.test(resourceTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceTags. No match found.");
    return setNewResourceTagLike(index, buildResourceTag(index));
  }
  
  public A addToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").add(index, builder); serviceEndpoints.add(index, builder);}
    return (A)this;
  }
  
  public A setToServiceEndpoints(int index,AWSServiceEndpoint item) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
    if (index < 0 || index >= serviceEndpoints.size()) { _visitables.get("serviceEndpoints").add(builder); serviceEndpoints.add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder); serviceEndpoints.set(index, builder);}
    return (A)this;
  }
  
  public A addToServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
  }
  
  public A removeFromServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
    if (this.serviceEndpoints == null) return (A)this;
    for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder); this.serviceEndpoints.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
    if (serviceEndpoints == null) return (A) this;
    final Iterator<AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
    final List visitables = _visitables.get("serviceEndpoints");
    while (each.hasNext()) {
      AWSServiceEndpointBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AWSServiceEndpoint> buildServiceEndpoints() {
    return this.serviceEndpoints != null ? build(serviceEndpoints) : null;
  }
  
  public AWSServiceEndpoint buildServiceEndpoint(int index) {
    return this.serviceEndpoints.get(index).build();
  }
  
  public AWSServiceEndpoint buildFirstServiceEndpoint() {
    return this.serviceEndpoints.get(0).build();
  }
  
  public AWSServiceEndpoint buildLastServiceEndpoint() {
    return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
  }
  
  public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
      for (AWSServiceEndpointBuilder item : serviceEndpoints) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
      for (AWSServiceEndpointBuilder item : serviceEndpoints) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
    if (this.serviceEndpoints != null) {
      this._visitables.get("serviceEndpoints").clear();
    }
    if (serviceEndpoints != null) {
        this.serviceEndpoints = new ArrayList();
        for (AWSServiceEndpoint item : serviceEndpoints) {
          this.addToServiceEndpoints(item);
        }
    } else {
      this.serviceEndpoints = null;
    }
    return (A) this;
  }
  
  public A withServiceEndpoints(io.fabric8.openshift.api.model.config.v1.AWSServiceEndpoint... serviceEndpoints) {
    if (this.serviceEndpoints != null) {this.serviceEndpoints.clear(); _visitables.remove("serviceEndpoints"); }
    if (serviceEndpoints != null) {for (AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
  }
  
  public boolean hasServiceEndpoints() {
    return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
  }
  
  public A addNewServiceEndpoint(String name,String url) {
    return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpoint() {
    return new ServiceEndpointsNested(-1, null);
  }
  
  public ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
    return new ServiceEndpointsNested(-1, item);
  }
  
  public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item) {
    return new ServiceEndpointsNested(index, item);
  }
  
  public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
    if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
    if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
  }
  
  public ServiceEndpointsNested<A> editLastServiceEndpoint() {
    int index = serviceEndpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceEndpoints.size();i++) { 
    if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
    return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPlatformStatusFluent that = (AWSPlatformStatusFluent) o;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(resourceTags, that.resourceTags)) return false;
    if (!java.util.Objects.equals(serviceEndpoints, that.serviceEndpoints)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(region,  resourceTags,  serviceEndpoints,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (resourceTags != null && !resourceTags.isEmpty()) { sb.append("resourceTags:"); sb.append(resourceTags + ","); }
    if (serviceEndpoints != null && !serviceEndpoints.isEmpty()) { sb.append("serviceEndpoints:"); sb.append(serviceEndpoints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourceTagsNested<N> extends AWSResourceTagFluent<ResourceTagsNested<N>> implements Nested<N>{
    ResourceTagsNested(int index,AWSResourceTag item) {
      this.index = index;
      this.builder = new AWSResourceTagBuilder(this, item);
    }
    AWSResourceTagBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSPlatformStatusFluent.this.setToResourceTags(index,builder.build());
    }
    
    public N endResourceTag() {
      return and();
    }
    
  
  }
  public class ServiceEndpointsNested<N> extends AWSServiceEndpointFluent<ServiceEndpointsNested<N>> implements Nested<N>{
    ServiceEndpointsNested(int index,AWSServiceEndpoint item) {
      this.index = index;
      this.builder = new AWSServiceEndpointBuilder(this, item);
    }
    AWSServiceEndpointBuilder builder;
    int index;
    
    public N and() {
      return (N) AWSPlatformStatusFluent.this.setToServiceEndpoints(index,builder.build());
    }
    
    public N endServiceEndpoint() {
      return and();
    }
    
  
  }

}