package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IBMCloudPlatformStatusFluent<A extends IBMCloudPlatformStatusFluent<A>> extends BaseFluent<A>{
  public IBMCloudPlatformStatusFluent() {
  }
  
  public IBMCloudPlatformStatusFluent(IBMCloudPlatformStatus instance) {
    this.copyInstance(instance);
  }
  private String cisInstanceCRN;
  private String dnsInstanceCRN;
  private String location;
  private String providerType;
  private String resourceGroupName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IBMCloudPlatformStatus instance) {
    instance = (instance != null ? instance : new IBMCloudPlatformStatus());
    if (instance != null) {
          this.withCisInstanceCRN(instance.getCisInstanceCRN());
          this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
          this.withLocation(instance.getLocation());
          this.withProviderType(instance.getProviderType());
          this.withResourceGroupName(instance.getResourceGroupName());
          this.withCisInstanceCRN(instance.getCisInstanceCRN());
          this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
          this.withLocation(instance.getLocation());
          this.withProviderType(instance.getProviderType());
          this.withResourceGroupName(instance.getResourceGroupName());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCisInstanceCRN() {
    return this.cisInstanceCRN;
  }
  
  public A withCisInstanceCRN(String cisInstanceCRN) {
    this.cisInstanceCRN = cisInstanceCRN;
    return (A) this;
  }
  
  public boolean hasCisInstanceCRN() {
    return this.cisInstanceCRN != null;
  }
  
  public String getDnsInstanceCRN() {
    return this.dnsInstanceCRN;
  }
  
  public A withDnsInstanceCRN(String dnsInstanceCRN) {
    this.dnsInstanceCRN = dnsInstanceCRN;
    return (A) this;
  }
  
  public boolean hasDnsInstanceCRN() {
    return this.dnsInstanceCRN != null;
  }
  
  public String getLocation() {
    return this.location;
  }
  
  public A withLocation(String location) {
    this.location = location;
    return (A) this;
  }
  
  public boolean hasLocation() {
    return this.location != null;
  }
  
  public String getProviderType() {
    return this.providerType;
  }
  
  public A withProviderType(String providerType) {
    this.providerType = providerType;
    return (A) this;
  }
  
  public boolean hasProviderType() {
    return this.providerType != null;
  }
  
  public String getResourceGroupName() {
    return this.resourceGroupName;
  }
  
  public A withResourceGroupName(String resourceGroupName) {
    this.resourceGroupName = resourceGroupName;
    return (A) this;
  }
  
  public boolean hasResourceGroupName() {
    return this.resourceGroupName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IBMCloudPlatformStatusFluent that = (IBMCloudPlatformStatusFluent) o;
    if (!java.util.Objects.equals(cisInstanceCRN, that.cisInstanceCRN)) return false;
    if (!java.util.Objects.equals(dnsInstanceCRN, that.dnsInstanceCRN)) return false;
    if (!java.util.Objects.equals(location, that.location)) return false;
    if (!java.util.Objects.equals(providerType, that.providerType)) return false;
    if (!java.util.Objects.equals(resourceGroupName, that.resourceGroupName)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cisInstanceCRN,  dnsInstanceCRN,  location,  providerType,  resourceGroupName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cisInstanceCRN != null) { sb.append("cisInstanceCRN:"); sb.append(cisInstanceCRN + ","); }
    if (dnsInstanceCRN != null) { sb.append("dnsInstanceCRN:"); sb.append(dnsInstanceCRN + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (providerType != null) { sb.append("providerType:"); sb.append(providerType + ","); }
    if (resourceGroupName != null) { sb.append("resourceGroupName:"); sb.append(resourceGroupName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}