package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VSpherePlatformSpecFluent<A extends VSpherePlatformSpecFluent<A>> extends BaseFluent<A>{
  public VSpherePlatformSpecFluent() {
  }
  
  public VSpherePlatformSpecFluent(VSpherePlatformSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<VSpherePlatformFailureDomainSpecBuilder> failureDomains = new ArrayList<VSpherePlatformFailureDomainSpecBuilder>();
  private VSpherePlatformNodeNetworkingBuilder nodeNetworking;
  private ArrayList<VSpherePlatformVCenterSpecBuilder> vcenters = new ArrayList<VSpherePlatformVCenterSpecBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VSpherePlatformSpec instance) {
    instance = (instance != null ? instance : new VSpherePlatformSpec());
    if (instance != null) {
          this.withFailureDomains(instance.getFailureDomains());
          this.withNodeNetworking(instance.getNodeNetworking());
          this.withVcenters(instance.getVcenters());
          this.withFailureDomains(instance.getFailureDomains());
          this.withNodeNetworking(instance.getNodeNetworking());
          this.withVcenters(instance.getVcenters());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFailureDomains(int index,VSpherePlatformFailureDomainSpec item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<VSpherePlatformFailureDomainSpecBuilder>();}
    VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").add(index, builder); failureDomains.add(index, builder);}
    return (A)this;
  }
  
  public A setToFailureDomains(int index,VSpherePlatformFailureDomainSpec item) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<VSpherePlatformFailureDomainSpecBuilder>();}
    VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);
    if (index < 0 || index >= failureDomains.size()) { _visitables.get("failureDomains").add(builder); failureDomains.add(builder); } else { _visitables.get("failureDomains").set(index, builder); failureDomains.set(index, builder);}
    return (A)this;
  }
  
  public A addToFailureDomains(io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpec... items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<VSpherePlatformFailureDomainSpecBuilder>();}
    for (VSpherePlatformFailureDomainSpec item : items) {VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A addAllToFailureDomains(Collection<VSpherePlatformFailureDomainSpec> items) {
    if (this.failureDomains == null) {this.failureDomains = new ArrayList<VSpherePlatformFailureDomainSpecBuilder>();}
    for (VSpherePlatformFailureDomainSpec item : items) {VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);_visitables.get("failureDomains").add(builder);this.failureDomains.add(builder);} return (A)this;
  }
  
  public A removeFromFailureDomains(io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpec... items) {
    if (this.failureDomains == null) return (A)this;
    for (VSpherePlatformFailureDomainSpec item : items) {VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFailureDomains(Collection<VSpherePlatformFailureDomainSpec> items) {
    if (this.failureDomains == null) return (A)this;
    for (VSpherePlatformFailureDomainSpec item : items) {VSpherePlatformFailureDomainSpecBuilder builder = new VSpherePlatformFailureDomainSpecBuilder(item);_visitables.get("failureDomains").remove(builder); this.failureDomains.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFailureDomains(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
    if (failureDomains == null) return (A) this;
    final Iterator<VSpherePlatformFailureDomainSpecBuilder> each = failureDomains.iterator();
    final List visitables = _visitables.get("failureDomains");
    while (each.hasNext()) {
      VSpherePlatformFailureDomainSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VSpherePlatformFailureDomainSpec> buildFailureDomains() {
    return this.failureDomains != null ? build(failureDomains) : null;
  }
  
  public VSpherePlatformFailureDomainSpec buildFailureDomain(int index) {
    return this.failureDomains.get(index).build();
  }
  
  public VSpherePlatformFailureDomainSpec buildFirstFailureDomain() {
    return this.failureDomains.get(0).build();
  }
  
  public VSpherePlatformFailureDomainSpec buildLastFailureDomain() {
    return this.failureDomains.get(failureDomains.size() - 1).build();
  }
  
  public VSpherePlatformFailureDomainSpec buildMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
      for (VSpherePlatformFailureDomainSpecBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
      for (VSpherePlatformFailureDomainSpecBuilder item : failureDomains) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFailureDomains(List<VSpherePlatformFailureDomainSpec> failureDomains) {
    if (this.failureDomains != null) {
      this._visitables.get("failureDomains").clear();
    }
    if (failureDomains != null) {
        this.failureDomains = new ArrayList();
        for (VSpherePlatformFailureDomainSpec item : failureDomains) {
          this.addToFailureDomains(item);
        }
    } else {
      this.failureDomains = null;
    }
    return (A) this;
  }
  
  public A withFailureDomains(io.fabric8.openshift.api.model.config.v1.VSpherePlatformFailureDomainSpec... failureDomains) {
    if (this.failureDomains != null) {this.failureDomains.clear(); _visitables.remove("failureDomains"); }
    if (failureDomains != null) {for (VSpherePlatformFailureDomainSpec item :failureDomains){ this.addToFailureDomains(item);}} return (A) this;
  }
  
  public boolean hasFailureDomains() {
    return this.failureDomains != null && !this.failureDomains.isEmpty();
  }
  
  public FailureDomainsNested<A> addNewFailureDomain() {
    return new FailureDomainsNested(-1, null);
  }
  
  public FailureDomainsNested<A> addNewFailureDomainLike(VSpherePlatformFailureDomainSpec item) {
    return new FailureDomainsNested(-1, item);
  }
  
  public FailureDomainsNested<A> setNewFailureDomainLike(int index,VSpherePlatformFailureDomainSpec item) {
    return new FailureDomainsNested(index, item);
  }
  
  public FailureDomainsNested<A> editFailureDomain(int index) {
    if (failureDomains.size() <= index) throw new RuntimeException("Can't edit failureDomains. Index exceeds size.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editFirstFailureDomain() {
    if (failureDomains.size() == 0) throw new RuntimeException("Can't edit first failureDomains. The list is empty.");
    return setNewFailureDomainLike(0, buildFailureDomain(0));
  }
  
  public FailureDomainsNested<A> editLastFailureDomain() {
    int index = failureDomains.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last failureDomains. The list is empty.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public FailureDomainsNested<A> editMatchingFailureDomain(Predicate<VSpherePlatformFailureDomainSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<failureDomains.size();i++) { 
    if (predicate.test(failureDomains.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching failureDomains. No match found.");
    return setNewFailureDomainLike(index, buildFailureDomain(index));
  }
  
  public VSpherePlatformNodeNetworking buildNodeNetworking() {
    return this.nodeNetworking != null ? this.nodeNetworking.build() : null;
  }
  
  public A withNodeNetworking(VSpherePlatformNodeNetworking nodeNetworking) {
    this._visitables.remove(this.nodeNetworking);
    if (nodeNetworking != null) {
        this.nodeNetworking = new VSpherePlatformNodeNetworkingBuilder(nodeNetworking);
        this._visitables.get("nodeNetworking").add(this.nodeNetworking);
    } else {
        this.nodeNetworking = null;
        this._visitables.get("nodeNetworking").remove(this.nodeNetworking);
    }
    return (A) this;
  }
  
  public boolean hasNodeNetworking() {
    return this.nodeNetworking != null;
  }
  
  public NodeNetworkingNested<A> withNewNodeNetworking() {
    return new NodeNetworkingNested(null);
  }
  
  public NodeNetworkingNested<A> withNewNodeNetworkingLike(VSpherePlatformNodeNetworking item) {
    return new NodeNetworkingNested(item);
  }
  
  public NodeNetworkingNested<A> editNodeNetworking() {
    return withNewNodeNetworkingLike(java.util.Optional.ofNullable(buildNodeNetworking()).orElse(null));
  }
  
  public NodeNetworkingNested<A> editOrNewNodeNetworking() {
    return withNewNodeNetworkingLike(java.util.Optional.ofNullable(buildNodeNetworking()).orElse(new VSpherePlatformNodeNetworkingBuilder().build()));
  }
  
  public NodeNetworkingNested<A> editOrNewNodeNetworkingLike(VSpherePlatformNodeNetworking item) {
    return withNewNodeNetworkingLike(java.util.Optional.ofNullable(buildNodeNetworking()).orElse(item));
  }
  
  public A addToVcenters(int index,VSpherePlatformVCenterSpec item) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VSpherePlatformVCenterSpecBuilder>();}
    VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
    if (index < 0 || index >= vcenters.size()) { _visitables.get("vcenters").add(builder); vcenters.add(builder); } else { _visitables.get("vcenters").add(index, builder); vcenters.add(index, builder);}
    return (A)this;
  }
  
  public A setToVcenters(int index,VSpherePlatformVCenterSpec item) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VSpherePlatformVCenterSpecBuilder>();}
    VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);
    if (index < 0 || index >= vcenters.size()) { _visitables.get("vcenters").add(builder); vcenters.add(builder); } else { _visitables.get("vcenters").set(index, builder); vcenters.set(index, builder);}
    return (A)this;
  }
  
  public A addToVcenters(io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpec... items) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VSpherePlatformVCenterSpecBuilder>();}
    for (VSpherePlatformVCenterSpec item : items) {VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);_visitables.get("vcenters").add(builder);this.vcenters.add(builder);} return (A)this;
  }
  
  public A addAllToVcenters(Collection<VSpherePlatformVCenterSpec> items) {
    if (this.vcenters == null) {this.vcenters = new ArrayList<VSpherePlatformVCenterSpecBuilder>();}
    for (VSpherePlatformVCenterSpec item : items) {VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);_visitables.get("vcenters").add(builder);this.vcenters.add(builder);} return (A)this;
  }
  
  public A removeFromVcenters(io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpec... items) {
    if (this.vcenters == null) return (A)this;
    for (VSpherePlatformVCenterSpec item : items) {VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);_visitables.get("vcenters").remove(builder); this.vcenters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVcenters(Collection<VSpherePlatformVCenterSpec> items) {
    if (this.vcenters == null) return (A)this;
    for (VSpherePlatformVCenterSpec item : items) {VSpherePlatformVCenterSpecBuilder builder = new VSpherePlatformVCenterSpecBuilder(item);_visitables.get("vcenters").remove(builder); this.vcenters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVcenters(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
    if (vcenters == null) return (A) this;
    final Iterator<VSpherePlatformVCenterSpecBuilder> each = vcenters.iterator();
    final List visitables = _visitables.get("vcenters");
    while (each.hasNext()) {
      VSpherePlatformVCenterSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VSpherePlatformVCenterSpec> buildVcenters() {
    return this.vcenters != null ? build(vcenters) : null;
  }
  
  public VSpherePlatformVCenterSpec buildVcenter(int index) {
    return this.vcenters.get(index).build();
  }
  
  public VSpherePlatformVCenterSpec buildFirstVcenter() {
    return this.vcenters.get(0).build();
  }
  
  public VSpherePlatformVCenterSpec buildLastVcenter() {
    return this.vcenters.get(vcenters.size() - 1).build();
  }
  
  public VSpherePlatformVCenterSpec buildMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
      for (VSpherePlatformVCenterSpecBuilder item : vcenters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
      for (VSpherePlatformVCenterSpecBuilder item : vcenters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVcenters(List<VSpherePlatformVCenterSpec> vcenters) {
    if (this.vcenters != null) {
      this._visitables.get("vcenters").clear();
    }
    if (vcenters != null) {
        this.vcenters = new ArrayList();
        for (VSpherePlatformVCenterSpec item : vcenters) {
          this.addToVcenters(item);
        }
    } else {
      this.vcenters = null;
    }
    return (A) this;
  }
  
  public A withVcenters(io.fabric8.openshift.api.model.config.v1.VSpherePlatformVCenterSpec... vcenters) {
    if (this.vcenters != null) {this.vcenters.clear(); _visitables.remove("vcenters"); }
    if (vcenters != null) {for (VSpherePlatformVCenterSpec item :vcenters){ this.addToVcenters(item);}} return (A) this;
  }
  
  public boolean hasVcenters() {
    return this.vcenters != null && !this.vcenters.isEmpty();
  }
  
  public VcentersNested<A> addNewVcenter() {
    return new VcentersNested(-1, null);
  }
  
  public VcentersNested<A> addNewVcenterLike(VSpherePlatformVCenterSpec item) {
    return new VcentersNested(-1, item);
  }
  
  public VcentersNested<A> setNewVcenterLike(int index,VSpherePlatformVCenterSpec item) {
    return new VcentersNested(index, item);
  }
  
  public VcentersNested<A> editVcenter(int index) {
    if (vcenters.size() <= index) throw new RuntimeException("Can't edit vcenters. Index exceeds size.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public VcentersNested<A> editFirstVcenter() {
    if (vcenters.size() == 0) throw new RuntimeException("Can't edit first vcenters. The list is empty.");
    return setNewVcenterLike(0, buildVcenter(0));
  }
  
  public VcentersNested<A> editLastVcenter() {
    int index = vcenters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last vcenters. The list is empty.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public VcentersNested<A> editMatchingVcenter(Predicate<VSpherePlatformVCenterSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<vcenters.size();i++) { 
    if (predicate.test(vcenters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching vcenters. No match found.");
    return setNewVcenterLike(index, buildVcenter(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VSpherePlatformSpecFluent that = (VSpherePlatformSpecFluent) o;
    if (!java.util.Objects.equals(failureDomains, that.failureDomains)) return false;
    if (!java.util.Objects.equals(nodeNetworking, that.nodeNetworking)) return false;
    if (!java.util.Objects.equals(vcenters, that.vcenters)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(failureDomains,  nodeNetworking,  vcenters,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (failureDomains != null && !failureDomains.isEmpty()) { sb.append("failureDomains:"); sb.append(failureDomains + ","); }
    if (nodeNetworking != null) { sb.append("nodeNetworking:"); sb.append(nodeNetworking + ","); }
    if (vcenters != null && !vcenters.isEmpty()) { sb.append("vcenters:"); sb.append(vcenters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FailureDomainsNested<N> extends VSpherePlatformFailureDomainSpecFluent<FailureDomainsNested<N>> implements Nested<N>{
    FailureDomainsNested(int index,VSpherePlatformFailureDomainSpec item) {
      this.index = index;
      this.builder = new VSpherePlatformFailureDomainSpecBuilder(this, item);
    }
    VSpherePlatformFailureDomainSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) VSpherePlatformSpecFluent.this.setToFailureDomains(index,builder.build());
    }
    
    public N endFailureDomain() {
      return and();
    }
    
  
  }
  public class NodeNetworkingNested<N> extends VSpherePlatformNodeNetworkingFluent<NodeNetworkingNested<N>> implements Nested<N>{
    NodeNetworkingNested(VSpherePlatformNodeNetworking item) {
      this.builder = new VSpherePlatformNodeNetworkingBuilder(this, item);
    }
    VSpherePlatformNodeNetworkingBuilder builder;
    
    public N and() {
      return (N) VSpherePlatformSpecFluent.this.withNodeNetworking(builder.build());
    }
    
    public N endNodeNetworking() {
      return and();
    }
    
  
  }
  public class VcentersNested<N> extends VSpherePlatformVCenterSpecFluent<VcentersNested<N>> implements Nested<N>{
    VcentersNested(int index,VSpherePlatformVCenterSpec item) {
      this.index = index;
      this.builder = new VSpherePlatformVCenterSpecBuilder(this, item);
    }
    VSpherePlatformVCenterSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) VSpherePlatformSpecFluent.this.setToVcenters(index,builder.build());
    }
    
    public N endVcenter() {
      return and();
    }
    
  
  }

}