package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CertInfoFluent<A extends CertInfoFluent<A>> extends BaseFluent<A>{
  public CertInfoFluent() {
  }
  
  public CertInfoFluent(CertInfo instance) {
    this.copyInstance(instance);
  }
  private String certFile;
  private String keyFile;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CertInfo instance) {
    instance = (instance != null ? instance : new CertInfo());
    if (instance != null) {
          this.withCertFile(instance.getCertFile());
          this.withKeyFile(instance.getKeyFile());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCertFile() {
    return this.certFile;
  }
  
  public A withCertFile(String certFile) {
    this.certFile = certFile;
    return (A) this;
  }
  
  public boolean hasCertFile() {
    return this.certFile != null;
  }
  
  public String getKeyFile() {
    return this.keyFile;
  }
  
  public A withKeyFile(String keyFile) {
    this.keyFile = keyFile;
    return (A) this;
  }
  
  public boolean hasKeyFile() {
    return this.keyFile != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertInfoFluent that = (CertInfoFluent) o;
    if (!java.util.Objects.equals(certFile, that.certFile)) return false;
    if (!java.util.Objects.equals(keyFile, that.keyFile)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(certFile,  keyFile,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certFile != null) { sb.append("certFile:"); sb.append(certFile + ","); }
    if (keyFile != null) { sb.append("keyFile:"); sb.append(keyFile + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}