package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenStackPlatformStatusFluent<A extends OpenStackPlatformStatusFluent<A>> extends BaseFluent<A>{
  public OpenStackPlatformStatusFluent() {
  }
  
  public OpenStackPlatformStatusFluent(OpenStackPlatformStatus instance) {
    this.copyInstance(instance);
  }
  private String apiServerInternalIP;
  private List<String> apiServerInternalIPs = new ArrayList<String>();
  private String cloudName;
  private String ingressIP;
  private List<String> ingressIPs = new ArrayList<String>();
  private OpenStackPlatformLoadBalancerBuilder loadBalancer;
  private List<String> machineNetworks = new ArrayList<String>();
  private String nodeDNSIP;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpenStackPlatformStatus instance) {
    instance = (instance != null ? instance : new OpenStackPlatformStatus());
    if (instance != null) {
          this.withApiServerInternalIP(instance.getApiServerInternalIP());
          this.withApiServerInternalIPs(instance.getApiServerInternalIPs());
          this.withCloudName(instance.getCloudName());
          this.withIngressIP(instance.getIngressIP());
          this.withIngressIPs(instance.getIngressIPs());
          this.withLoadBalancer(instance.getLoadBalancer());
          this.withMachineNetworks(instance.getMachineNetworks());
          this.withNodeDNSIP(instance.getNodeDNSIP());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiServerInternalIP() {
    return this.apiServerInternalIP;
  }
  
  public A withApiServerInternalIP(String apiServerInternalIP) {
    this.apiServerInternalIP = apiServerInternalIP;
    return (A) this;
  }
  
  public boolean hasApiServerInternalIP() {
    return this.apiServerInternalIP != null;
  }
  
  public A addToApiServerInternalIPs(int index,String item) {
    if (this.apiServerInternalIPs == null) {this.apiServerInternalIPs = new ArrayList<String>();}
    this.apiServerInternalIPs.add(index, item);
    return (A)this;
  }
  
  public A setToApiServerInternalIPs(int index,String item) {
    if (this.apiServerInternalIPs == null) {this.apiServerInternalIPs = new ArrayList<String>();}
    this.apiServerInternalIPs.set(index, item); return (A)this;
  }
  
  public A addToApiServerInternalIPs(java.lang.String... items) {
    if (this.apiServerInternalIPs == null) {this.apiServerInternalIPs = new ArrayList<String>();}
    for (String item : items) {this.apiServerInternalIPs.add(item);} return (A)this;
  }
  
  public A addAllToApiServerInternalIPs(Collection<String> items) {
    if (this.apiServerInternalIPs == null) {this.apiServerInternalIPs = new ArrayList<String>();}
    for (String item : items) {this.apiServerInternalIPs.add(item);} return (A)this;
  }
  
  public A removeFromApiServerInternalIPs(java.lang.String... items) {
    if (this.apiServerInternalIPs == null) return (A)this;
    for (String item : items) { this.apiServerInternalIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromApiServerInternalIPs(Collection<String> items) {
    if (this.apiServerInternalIPs == null) return (A)this;
    for (String item : items) { this.apiServerInternalIPs.remove(item);} return (A)this;
  }
  
  public List<String> getApiServerInternalIPs() {
    return this.apiServerInternalIPs;
  }
  
  public String getApiServerInternalIP(int index) {
    return this.apiServerInternalIPs.get(index);
  }
  
  public String getFirstApiServerInternalIP() {
    return this.apiServerInternalIPs.get(0);
  }
  
  public String getLastApiServerInternalIP() {
    return this.apiServerInternalIPs.get(apiServerInternalIPs.size() - 1);
  }
  
  public String getMatchingApiServerInternalIP(Predicate<String> predicate) {
      for (String item : apiServerInternalIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingApiServerInternalIP(Predicate<String> predicate) {
      for (String item : apiServerInternalIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withApiServerInternalIPs(List<String> apiServerInternalIPs) {
    if (apiServerInternalIPs != null) {
        this.apiServerInternalIPs = new ArrayList();
        for (String item : apiServerInternalIPs) {
          this.addToApiServerInternalIPs(item);
        }
    } else {
      this.apiServerInternalIPs = null;
    }
    return (A) this;
  }
  
  public A withApiServerInternalIPs(java.lang.String... apiServerInternalIPs) {
    if (this.apiServerInternalIPs != null) {
        this.apiServerInternalIPs.clear();
        _visitables.remove("apiServerInternalIPs");
    }
    if (apiServerInternalIPs != null) {
      for (String item : apiServerInternalIPs) {
        this.addToApiServerInternalIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasApiServerInternalIPs() {
    return this.apiServerInternalIPs != null && !this.apiServerInternalIPs.isEmpty();
  }
  
  public String getCloudName() {
    return this.cloudName;
  }
  
  public A withCloudName(String cloudName) {
    this.cloudName = cloudName;
    return (A) this;
  }
  
  public boolean hasCloudName() {
    return this.cloudName != null;
  }
  
  public String getIngressIP() {
    return this.ingressIP;
  }
  
  public A withIngressIP(String ingressIP) {
    this.ingressIP = ingressIP;
    return (A) this;
  }
  
  public boolean hasIngressIP() {
    return this.ingressIP != null;
  }
  
  public A addToIngressIPs(int index,String item) {
    if (this.ingressIPs == null) {this.ingressIPs = new ArrayList<String>();}
    this.ingressIPs.add(index, item);
    return (A)this;
  }
  
  public A setToIngressIPs(int index,String item) {
    if (this.ingressIPs == null) {this.ingressIPs = new ArrayList<String>();}
    this.ingressIPs.set(index, item); return (A)this;
  }
  
  public A addToIngressIPs(java.lang.String... items) {
    if (this.ingressIPs == null) {this.ingressIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressIPs.add(item);} return (A)this;
  }
  
  public A addAllToIngressIPs(Collection<String> items) {
    if (this.ingressIPs == null) {this.ingressIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressIPs.add(item);} return (A)this;
  }
  
  public A removeFromIngressIPs(java.lang.String... items) {
    if (this.ingressIPs == null) return (A)this;
    for (String item : items) { this.ingressIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromIngressIPs(Collection<String> items) {
    if (this.ingressIPs == null) return (A)this;
    for (String item : items) { this.ingressIPs.remove(item);} return (A)this;
  }
  
  public List<String> getIngressIPs() {
    return this.ingressIPs;
  }
  
  public String getIngressIP(int index) {
    return this.ingressIPs.get(index);
  }
  
  public String getFirstIngressIP() {
    return this.ingressIPs.get(0);
  }
  
  public String getLastIngressIP() {
    return this.ingressIPs.get(ingressIPs.size() - 1);
  }
  
  public String getMatchingIngressIP(Predicate<String> predicate) {
      for (String item : ingressIPs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingIngressIP(Predicate<String> predicate) {
      for (String item : ingressIPs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIngressIPs(List<String> ingressIPs) {
    if (ingressIPs != null) {
        this.ingressIPs = new ArrayList();
        for (String item : ingressIPs) {
          this.addToIngressIPs(item);
        }
    } else {
      this.ingressIPs = null;
    }
    return (A) this;
  }
  
  public A withIngressIPs(java.lang.String... ingressIPs) {
    if (this.ingressIPs != null) {
        this.ingressIPs.clear();
        _visitables.remove("ingressIPs");
    }
    if (ingressIPs != null) {
      for (String item : ingressIPs) {
        this.addToIngressIPs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIngressIPs() {
    return this.ingressIPs != null && !this.ingressIPs.isEmpty();
  }
  
  public OpenStackPlatformLoadBalancer buildLoadBalancer() {
    return this.loadBalancer != null ? this.loadBalancer.build() : null;
  }
  
  public A withLoadBalancer(OpenStackPlatformLoadBalancer loadBalancer) {
    this._visitables.remove("loadBalancer");
    if (loadBalancer != null) {
        this.loadBalancer = new OpenStackPlatformLoadBalancerBuilder(loadBalancer);
        this._visitables.get("loadBalancer").add(this.loadBalancer);
    } else {
        this.loadBalancer = null;
        this._visitables.get("loadBalancer").remove(this.loadBalancer);
    }
    return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public A withNewLoadBalancer(String type) {
    return (A)withLoadBalancer(new OpenStackPlatformLoadBalancer(type));
  }
  
  public LoadBalancerNested<A> withNewLoadBalancer() {
    return new LoadBalancerNested(null);
  }
  
  public LoadBalancerNested<A> withNewLoadBalancerLike(OpenStackPlatformLoadBalancer item) {
    return new LoadBalancerNested(item);
  }
  
  public LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(null));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(new OpenStackPlatformLoadBalancerBuilder().build()));
  }
  
  public LoadBalancerNested<A> editOrNewLoadBalancerLike(OpenStackPlatformLoadBalancer item) {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(item));
  }
  
  public A addToMachineNetworks(int index,String item) {
    if (this.machineNetworks == null) {this.machineNetworks = new ArrayList<String>();}
    this.machineNetworks.add(index, item);
    return (A)this;
  }
  
  public A setToMachineNetworks(int index,String item) {
    if (this.machineNetworks == null) {this.machineNetworks = new ArrayList<String>();}
    this.machineNetworks.set(index, item); return (A)this;
  }
  
  public A addToMachineNetworks(java.lang.String... items) {
    if (this.machineNetworks == null) {this.machineNetworks = new ArrayList<String>();}
    for (String item : items) {this.machineNetworks.add(item);} return (A)this;
  }
  
  public A addAllToMachineNetworks(Collection<String> items) {
    if (this.machineNetworks == null) {this.machineNetworks = new ArrayList<String>();}
    for (String item : items) {this.machineNetworks.add(item);} return (A)this;
  }
  
  public A removeFromMachineNetworks(java.lang.String... items) {
    if (this.machineNetworks == null) return (A)this;
    for (String item : items) { this.machineNetworks.remove(item);} return (A)this;
  }
  
  public A removeAllFromMachineNetworks(Collection<String> items) {
    if (this.machineNetworks == null) return (A)this;
    for (String item : items) { this.machineNetworks.remove(item);} return (A)this;
  }
  
  public List<String> getMachineNetworks() {
    return this.machineNetworks;
  }
  
  public String getMachineNetwork(int index) {
    return this.machineNetworks.get(index);
  }
  
  public String getFirstMachineNetwork() {
    return this.machineNetworks.get(0);
  }
  
  public String getLastMachineNetwork() {
    return this.machineNetworks.get(machineNetworks.size() - 1);
  }
  
  public String getMatchingMachineNetwork(Predicate<String> predicate) {
      for (String item : machineNetworks) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMachineNetwork(Predicate<String> predicate) {
      for (String item : machineNetworks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMachineNetworks(List<String> machineNetworks) {
    if (machineNetworks != null) {
        this.machineNetworks = new ArrayList();
        for (String item : machineNetworks) {
          this.addToMachineNetworks(item);
        }
    } else {
      this.machineNetworks = null;
    }
    return (A) this;
  }
  
  public A withMachineNetworks(java.lang.String... machineNetworks) {
    if (this.machineNetworks != null) {
        this.machineNetworks.clear();
        _visitables.remove("machineNetworks");
    }
    if (machineNetworks != null) {
      for (String item : machineNetworks) {
        this.addToMachineNetworks(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMachineNetworks() {
    return this.machineNetworks != null && !this.machineNetworks.isEmpty();
  }
  
  public String getNodeDNSIP() {
    return this.nodeDNSIP;
  }
  
  public A withNodeDNSIP(String nodeDNSIP) {
    this.nodeDNSIP = nodeDNSIP;
    return (A) this;
  }
  
  public boolean hasNodeDNSIP() {
    return this.nodeDNSIP != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenStackPlatformStatusFluent that = (OpenStackPlatformStatusFluent) o;
    if (!java.util.Objects.equals(apiServerInternalIP, that.apiServerInternalIP)) return false;
    if (!java.util.Objects.equals(apiServerInternalIPs, that.apiServerInternalIPs)) return false;
    if (!java.util.Objects.equals(cloudName, that.cloudName)) return false;
    if (!java.util.Objects.equals(ingressIP, that.ingressIP)) return false;
    if (!java.util.Objects.equals(ingressIPs, that.ingressIPs)) return false;
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
    if (!java.util.Objects.equals(machineNetworks, that.machineNetworks)) return false;
    if (!java.util.Objects.equals(nodeDNSIP, that.nodeDNSIP)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiServerInternalIP,  apiServerInternalIPs,  cloudName,  ingressIP,  ingressIPs,  loadBalancer,  machineNetworks,  nodeDNSIP,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiServerInternalIP != null) { sb.append("apiServerInternalIP:"); sb.append(apiServerInternalIP + ","); }
    if (apiServerInternalIPs != null && !apiServerInternalIPs.isEmpty()) { sb.append("apiServerInternalIPs:"); sb.append(apiServerInternalIPs + ","); }
    if (cloudName != null) { sb.append("cloudName:"); sb.append(cloudName + ","); }
    if (ingressIP != null) { sb.append("ingressIP:"); sb.append(ingressIP + ","); }
    if (ingressIPs != null && !ingressIPs.isEmpty()) { sb.append("ingressIPs:"); sb.append(ingressIPs + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (machineNetworks != null && !machineNetworks.isEmpty()) { sb.append("machineNetworks:"); sb.append(machineNetworks + ","); }
    if (nodeDNSIP != null) { sb.append("nodeDNSIP:"); sb.append(nodeDNSIP + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LoadBalancerNested<N> extends OpenStackPlatformLoadBalancerFluent<LoadBalancerNested<N>> implements Nested<N>{
    LoadBalancerNested(OpenStackPlatformLoadBalancer item) {
      this.builder = new OpenStackPlatformLoadBalancerBuilder(this, item);
    }
    OpenStackPlatformLoadBalancerBuilder builder;
    
    public N and() {
      return (N) OpenStackPlatformStatusFluent.this.withLoadBalancer(builder.build());
    }
    
    public N endLoadBalancer() {
      return and();
    }
    
  
  }

}