/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.DNSPlatformSpec;
import io.fabric8.openshift.api.model.config.v1.DNSPlatformSpecBuilder;
import io.fabric8.openshift.api.model.config.v1.DNSPlatformSpecFluent;
import io.fabric8.openshift.api.model.config.v1.DNSSpec;
import io.fabric8.openshift.api.model.config.v1.DNSZone;
import io.fabric8.openshift.api.model.config.v1.DNSZoneBuilder;
import io.fabric8.openshift.api.model.config.v1.DNSZoneFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DNSSpecFluent<A extends DNSSpecFluent<A>>
extends BaseFluent<A> {
    private String baseDomain;
    private DNSPlatformSpecBuilder platform;
    private DNSZoneBuilder privateZone;
    private DNSZoneBuilder publicZone;
    private Map<String, Object> additionalProperties;

    public DNSSpecFluent() {
    }

    public DNSSpecFluent(DNSSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DNSSpec instance) {
        DNSSpec dNSSpec = instance = instance != null ? instance : new DNSSpec();
        if (instance != null) {
            this.withBaseDomain(instance.getBaseDomain());
            this.withPlatform(instance.getPlatform());
            this.withPrivateZone(instance.getPrivateZone());
            this.withPublicZone(instance.getPublicZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBaseDomain() {
        return this.baseDomain;
    }

    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)((Object)this);
    }

    public boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    public DNSPlatformSpec buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    public A withPlatform(DNSPlatformSpec platform) {
        this._visitables.remove((Object)"platform");
        if (platform != null) {
            this.platform = new DNSPlatformSpecBuilder(platform);
            this._visitables.get((Object)"platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get((Object)"platform").remove((Object)this.platform);
        }
        return (A)((Object)this);
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public PlatformNested<A> withNewPlatform() {
        return new PlatformNested(null);
    }

    public PlatformNested<A> withNewPlatformLike(DNSPlatformSpec item) {
        return new PlatformNested(item);
    }

    public PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(null));
    }

    public PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(new DNSPlatformSpecBuilder().build()));
    }

    public PlatformNested<A> editOrNewPlatformLike(DNSPlatformSpec item) {
        return this.withNewPlatformLike(Optional.ofNullable(this.buildPlatform()).orElse(item));
    }

    public DNSZone buildPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    public A withPrivateZone(DNSZone privateZone) {
        this._visitables.remove((Object)"privateZone");
        if (privateZone != null) {
            this.privateZone = new DNSZoneBuilder(privateZone);
            this._visitables.get((Object)"privateZone").add(this.privateZone);
        } else {
            this.privateZone = null;
            this._visitables.get((Object)"privateZone").remove((Object)this.privateZone);
        }
        return (A)((Object)this);
    }

    public boolean hasPrivateZone() {
        return this.privateZone != null;
    }

    public PrivateZoneNested<A> withNewPrivateZone() {
        return new PrivateZoneNested(null);
    }

    public PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
        return new PrivateZoneNested(item);
    }

    public PrivateZoneNested<A> editPrivateZone() {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(null));
    }

    public PrivateZoneNested<A> editOrNewPrivateZone() {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(new DNSZoneBuilder().build()));
    }

    public PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
        return this.withNewPrivateZoneLike(Optional.ofNullable(this.buildPrivateZone()).orElse(item));
    }

    public DNSZone buildPublicZone() {
        return this.publicZone != null ? this.publicZone.build() : null;
    }

    public A withPublicZone(DNSZone publicZone) {
        this._visitables.remove((Object)"publicZone");
        if (publicZone != null) {
            this.publicZone = new DNSZoneBuilder(publicZone);
            this._visitables.get((Object)"publicZone").add(this.publicZone);
        } else {
            this.publicZone = null;
            this._visitables.get((Object)"publicZone").remove((Object)this.publicZone);
        }
        return (A)((Object)this);
    }

    public boolean hasPublicZone() {
        return this.publicZone != null;
    }

    public PublicZoneNested<A> withNewPublicZone() {
        return new PublicZoneNested(null);
    }

    public PublicZoneNested<A> withNewPublicZoneLike(DNSZone item) {
        return new PublicZoneNested(item);
    }

    public PublicZoneNested<A> editPublicZone() {
        return this.withNewPublicZoneLike(Optional.ofNullable(this.buildPublicZone()).orElse(null));
    }

    public PublicZoneNested<A> editOrNewPublicZone() {
        return this.withNewPublicZoneLike(Optional.ofNullable(this.buildPublicZone()).orElse(new DNSZoneBuilder().build()));
    }

    public PublicZoneNested<A> editOrNewPublicZoneLike(DNSZone item) {
        return this.withNewPublicZoneLike(Optional.ofNullable(this.buildPublicZone()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DNSSpecFluent that = (DNSSpecFluent)((Object)o);
        if (!Objects.equals(this.baseDomain, that.baseDomain)) {
            return false;
        }
        if (!Objects.equals((Object)this.platform, (Object)that.platform)) {
            return false;
        }
        if (!Objects.equals((Object)this.privateZone, (Object)that.privateZone)) {
            return false;
        }
        if (!Objects.equals((Object)this.publicZone, (Object)that.publicZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseDomain, this.platform, this.privateZone, this.publicZone, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseDomain != null) {
            sb.append("baseDomain:");
            sb.append(this.baseDomain + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(String.valueOf((Object)this.platform) + ",");
        }
        if (this.privateZone != null) {
            sb.append("privateZone:");
            sb.append(String.valueOf((Object)this.privateZone) + ",");
        }
        if (this.publicZone != null) {
            sb.append("publicZone:");
            sb.append(String.valueOf((Object)this.publicZone) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PublicZoneNested<N>
    extends DNSZoneFluent<PublicZoneNested<N>>
    implements Nested<N> {
        DNSZoneBuilder builder;

        PublicZoneNested(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withPublicZone(this.builder.build());
        }

        public N endPublicZone() {
            return this.and();
        }
    }

    public class PrivateZoneNested<N>
    extends DNSZoneFluent<PrivateZoneNested<N>>
    implements Nested<N> {
        DNSZoneBuilder builder;

        PrivateZoneNested(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withPrivateZone(this.builder.build());
        }

        public N endPrivateZone() {
            return this.and();
        }
    }

    public class PlatformNested<N>
    extends DNSPlatformSpecFluent<PlatformNested<N>>
    implements Nested<N> {
        DNSPlatformSpecBuilder builder;

        PlatformNested(DNSPlatformSpec item) {
            this.builder = new DNSPlatformSpecBuilder(this, item);
        }

        public N and() {
            return (N)DNSSpecFluent.this.withPlatform(this.builder.build());
        }

        public N endPlatform() {
            return this.and();
        }
    }
}

