package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigMapNameReferenceBuilder extends ConfigMapNameReferenceFluent<ConfigMapNameReferenceBuilder> implements VisitableBuilder<ConfigMapNameReference,ConfigMapNameReferenceBuilder>{
  public ConfigMapNameReferenceBuilder() {
    this(new ConfigMapNameReference());
  }
  
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent) {
    this(fluent, new ConfigMapNameReference());
  }
  
  public ConfigMapNameReferenceBuilder(ConfigMapNameReferenceFluent<?> fluent,ConfigMapNameReference instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigMapNameReferenceBuilder(ConfigMapNameReference instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigMapNameReferenceFluent<?> fluent;
  
  public ConfigMapNameReference build() {
    ConfigMapNameReference buildable = new ConfigMapNameReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}