package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class KubeClientConfigBuilder extends KubeClientConfigFluent<KubeClientConfigBuilder> implements VisitableBuilder<KubeClientConfig,KubeClientConfigBuilder>{
  public KubeClientConfigBuilder() {
    this(new KubeClientConfig());
  }
  
  public KubeClientConfigBuilder(KubeClientConfigFluent<?> fluent) {
    this(fluent, new KubeClientConfig());
  }
  
  public KubeClientConfigBuilder(KubeClientConfigFluent<?> fluent,KubeClientConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public KubeClientConfigBuilder(KubeClientConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  KubeClientConfigFluent<?> fluent;
  
  public KubeClientConfig build() {
    KubeClientConfig buildable = new KubeClientConfig(fluent.buildConnectionOverrides(),fluent.getKubeConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}