package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SignatureStoreBuilder extends SignatureStoreFluent<SignatureStoreBuilder> implements VisitableBuilder<SignatureStore,SignatureStoreBuilder>{
  public SignatureStoreBuilder() {
    this(new SignatureStore());
  }
  
  public SignatureStoreBuilder(SignatureStoreFluent<?> fluent) {
    this(fluent, new SignatureStore());
  }
  
  public SignatureStoreBuilder(SignatureStoreFluent<?> fluent,SignatureStore instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SignatureStoreBuilder(SignatureStore instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SignatureStoreFluent<?> fluent;
  
  public SignatureStore build() {
    SignatureStore buildable = new SignatureStore(fluent.buildCa(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}