package io.fabric8.openshift.api.model.config.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TokenClaimMappingsFluent<A extends TokenClaimMappingsFluent<A>> extends BaseFluent<A>{
  public TokenClaimMappingsFluent() {
  }
  
  public TokenClaimMappingsFluent(TokenClaimMappings instance) {
    this.copyInstance(instance);
  }
  private PrefixedClaimMappingBuilder groups;
  private UsernameClaimMappingBuilder username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TokenClaimMappings instance) {
    instance = (instance != null ? instance : new TokenClaimMappings());
    if (instance != null) {
          this.withGroups(instance.getGroups());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PrefixedClaimMapping buildGroups() {
    return this.groups != null ? this.groups.build() : null;
  }
  
  public A withGroups(PrefixedClaimMapping groups) {
    this._visitables.remove("groups");
    if (groups != null) {
        this.groups = new PrefixedClaimMappingBuilder(groups);
        this._visitables.get("groups").add(this.groups);
    } else {
        this.groups = null;
        this._visitables.get("groups").remove(this.groups);
    }
    return (A) this;
  }
  
  public boolean hasGroups() {
    return this.groups != null;
  }
  
  public A withNewGroups(String claim,String prefix) {
    return (A)withGroups(new PrefixedClaimMapping(claim, prefix));
  }
  
  public GroupsNested<A> withNewGroups() {
    return new GroupsNested(null);
  }
  
  public GroupsNested<A> withNewGroupsLike(PrefixedClaimMapping item) {
    return new GroupsNested(item);
  }
  
  public GroupsNested<A> editGroups() {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(null));
  }
  
  public GroupsNested<A> editOrNewGroups() {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(new PrefixedClaimMappingBuilder().build()));
  }
  
  public GroupsNested<A> editOrNewGroupsLike(PrefixedClaimMapping item) {
    return withNewGroupsLike(java.util.Optional.ofNullable(buildGroups()).orElse(item));
  }
  
  public UsernameClaimMapping buildUsername() {
    return this.username != null ? this.username.build() : null;
  }
  
  public A withUsername(UsernameClaimMapping username) {
    this._visitables.remove("username");
    if (username != null) {
        this.username = new UsernameClaimMappingBuilder(username);
        this._visitables.get("username").add(this.username);
    } else {
        this.username = null;
        this._visitables.get("username").remove(this.username);
    }
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public UsernameNested<A> withNewUsername() {
    return new UsernameNested(null);
  }
  
  public UsernameNested<A> withNewUsernameLike(UsernameClaimMapping item) {
    return new UsernameNested(item);
  }
  
  public UsernameNested<A> editUsername() {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(null));
  }
  
  public UsernameNested<A> editOrNewUsername() {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(new UsernameClaimMappingBuilder().build()));
  }
  
  public UsernameNested<A> editOrNewUsernameLike(UsernameClaimMapping item) {
    return withNewUsernameLike(java.util.Optional.ofNullable(buildUsername()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenClaimMappingsFluent that = (TokenClaimMappingsFluent) o;
    if (!java.util.Objects.equals(groups, that.groups)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(groups,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (groups != null) { sb.append("groups:"); sb.append(groups + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class GroupsNested<N> extends PrefixedClaimMappingFluent<GroupsNested<N>> implements Nested<N>{
    GroupsNested(PrefixedClaimMapping item) {
      this.builder = new PrefixedClaimMappingBuilder(this, item);
    }
    PrefixedClaimMappingBuilder builder;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.withGroups(builder.build());
    }
    
    public N endGroups() {
      return and();
    }
    
  
  }
  public class UsernameNested<N> extends UsernameClaimMappingFluent<UsernameNested<N>> implements Nested<N>{
    UsernameNested(UsernameClaimMapping item) {
      this.builder = new UsernameClaimMappingBuilder(this, item);
    }
    UsernameClaimMappingBuilder builder;
    
    public N and() {
      return (N) TokenClaimMappingsFluent.this.withUsername(builder.build());
    }
    
    public N endUsername() {
      return and();
    }
    
  
  }

}