package io.fabric8.openshift.api.model.console.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleLinkSpecFluentImpl<A extends ConsoleLinkSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConsoleLinkSpecFluent<A> {

    private ApplicationMenuSpecBuilder applicationMenu;
    private String href;
    private String location;
    private NamespaceDashboardSpecBuilder namespaceDashboard;
    private String text;

    public ConsoleLinkSpecFluentImpl() { 
    }


    public ConsoleLinkSpecFluentImpl(ConsoleLinkSpec instance) { 
        this.withApplicationMenu(instance.getApplicationMenu()); 
        this.withHref(instance.getHref()); 
        this.withLocation(instance.getLocation()); 
        this.withNamespaceDashboard(instance.getNamespaceDashboard()); 
        this.withText(instance.getText()); 
    }


    
/**
 * This method has been deprecated, please use method buildApplicationMenu instead.
 * @return The buildable object.
 */
@Deprecated public ApplicationMenuSpec getApplicationMenu() {
        return this.applicationMenu!=null?this.applicationMenu.build():null;
    }

    public ApplicationMenuSpec buildApplicationMenu() {
        return this.applicationMenu!=null?this.applicationMenu.build():null;
    }

    public A withApplicationMenu(ApplicationMenuSpec applicationMenu) {
        _visitables.get("applicationMenu").remove(this.applicationMenu);
        if (applicationMenu!=null){ this.applicationMenu= new ApplicationMenuSpecBuilder(applicationMenu); _visitables.get("applicationMenu").add(this.applicationMenu);} return (A) this;
    }

    public Boolean hasApplicationMenu() {
        return this.applicationMenu != null;
    }

    public A withNewApplicationMenu(String imageURL,String section) {
        return (A)withApplicationMenu(new ApplicationMenuSpec(imageURL, section));
    }

    public ConsoleLinkSpecFluent.ApplicationMenuNested<A> withNewApplicationMenu() {
        return new ApplicationMenuNestedImpl();
    }

    public ConsoleLinkSpecFluent.ApplicationMenuNested<A> withNewApplicationMenuLike(ApplicationMenuSpec item) {
        return new ApplicationMenuNestedImpl(item);
    }

    public ConsoleLinkSpecFluent.ApplicationMenuNested<A> editApplicationMenu() {
        return withNewApplicationMenuLike(getApplicationMenu());
    }

    public ConsoleLinkSpecFluent.ApplicationMenuNested<A> editOrNewApplicationMenu() {
        return withNewApplicationMenuLike(getApplicationMenu() != null ? getApplicationMenu(): new ApplicationMenuSpecBuilder().build());
    }

    public ConsoleLinkSpecFluent.ApplicationMenuNested<A> editOrNewApplicationMenuLike(ApplicationMenuSpec item) {
        return withNewApplicationMenuLike(getApplicationMenu() != null ? getApplicationMenu(): item);
    }

    public String getHref() {
        return this.href;
    }

    public A withHref(String href) {
        this.href=href; return (A) this;
    }

    public Boolean hasHref() {
        return this.href != null;
    }

    public A withNewHref(String arg1) {
        return (A)withHref(new String(arg1));
    }

    public A withNewHref(StringBuilder arg1) {
        return (A)withHref(new String(arg1));
    }

    public A withNewHref(StringBuffer arg1) {
        return (A)withHref(new String(arg1));
    }

    public String getLocation() {
        return this.location;
    }

    public A withLocation(String location) {
        this.location=location; return (A) this;
    }

    public Boolean hasLocation() {
        return this.location != null;
    }

    public A withNewLocation(String arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuilder arg1) {
        return (A)withLocation(new String(arg1));
    }

    public A withNewLocation(StringBuffer arg1) {
        return (A)withLocation(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceDashboard instead.
 * @return The buildable object.
 */
@Deprecated public NamespaceDashboardSpec getNamespaceDashboard() {
        return this.namespaceDashboard!=null?this.namespaceDashboard.build():null;
    }

    public NamespaceDashboardSpec buildNamespaceDashboard() {
        return this.namespaceDashboard!=null?this.namespaceDashboard.build():null;
    }

    public A withNamespaceDashboard(NamespaceDashboardSpec namespaceDashboard) {
        _visitables.get("namespaceDashboard").remove(this.namespaceDashboard);
        if (namespaceDashboard!=null){ this.namespaceDashboard= new NamespaceDashboardSpecBuilder(namespaceDashboard); _visitables.get("namespaceDashboard").add(this.namespaceDashboard);} return (A) this;
    }

    public Boolean hasNamespaceDashboard() {
        return this.namespaceDashboard != null;
    }

    public ConsoleLinkSpecFluent.NamespaceDashboardNested<A> withNewNamespaceDashboard() {
        return new NamespaceDashboardNestedImpl();
    }

    public ConsoleLinkSpecFluent.NamespaceDashboardNested<A> withNewNamespaceDashboardLike(NamespaceDashboardSpec item) {
        return new NamespaceDashboardNestedImpl(item);
    }

    public ConsoleLinkSpecFluent.NamespaceDashboardNested<A> editNamespaceDashboard() {
        return withNewNamespaceDashboardLike(getNamespaceDashboard());
    }

    public ConsoleLinkSpecFluent.NamespaceDashboardNested<A> editOrNewNamespaceDashboard() {
        return withNewNamespaceDashboardLike(getNamespaceDashboard() != null ? getNamespaceDashboard(): new NamespaceDashboardSpecBuilder().build());
    }

    public ConsoleLinkSpecFluent.NamespaceDashboardNested<A> editOrNewNamespaceDashboardLike(NamespaceDashboardSpec item) {
        return withNewNamespaceDashboardLike(getNamespaceDashboard() != null ? getNamespaceDashboard(): item);
    }

    public String getText() {
        return this.text;
    }

    public A withText(String text) {
        this.text=text; return (A) this;
    }

    public Boolean hasText() {
        return this.text != null;
    }

    public A withNewText(String arg1) {
        return (A)withText(new String(arg1));
    }

    public A withNewText(StringBuilder arg1) {
        return (A)withText(new String(arg1));
    }

    public A withNewText(StringBuffer arg1) {
        return (A)withText(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConsoleLinkSpecFluentImpl that = (ConsoleLinkSpecFluentImpl) o;
        if (applicationMenu != null ? !applicationMenu.equals(that.applicationMenu) :that.applicationMenu != null) return false;
        if (href != null ? !href.equals(that.href) :that.href != null) return false;
        if (location != null ? !location.equals(that.location) :that.location != null) return false;
        if (namespaceDashboard != null ? !namespaceDashboard.equals(that.namespaceDashboard) :that.namespaceDashboard != null) return false;
        if (text != null ? !text.equals(that.text) :that.text != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(applicationMenu,  href,  location,  namespaceDashboard,  text,  super.hashCode());
    }

    public class ApplicationMenuNestedImpl<N> extends ApplicationMenuSpecFluentImpl<ConsoleLinkSpecFluent.ApplicationMenuNested<N>> implements ConsoleLinkSpecFluent.ApplicationMenuNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ApplicationMenuSpecBuilder builder;

        ApplicationMenuNestedImpl(ApplicationMenuSpec item) {
            this.builder = new ApplicationMenuSpecBuilder(this, item);
        }

        ApplicationMenuNestedImpl() {
            this.builder = new ApplicationMenuSpecBuilder(this);
        }

        public N and() {
             return (N) ConsoleLinkSpecFluentImpl.this.withApplicationMenu(builder.build());
        }

        public N endApplicationMenu() {
             return and();
        }
    }


    public class NamespaceDashboardNestedImpl<N> extends NamespaceDashboardSpecFluentImpl<ConsoleLinkSpecFluent.NamespaceDashboardNested<N>> implements ConsoleLinkSpecFluent.NamespaceDashboardNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final NamespaceDashboardSpecBuilder builder;

        NamespaceDashboardNestedImpl(NamespaceDashboardSpec item) {
            this.builder = new NamespaceDashboardSpecBuilder(this, item);
        }

        NamespaceDashboardNestedImpl() {
            this.builder = new NamespaceDashboardSpecBuilder(this);
        }

        public N and() {
             return (N) ConsoleLinkSpecFluentImpl.this.withNamespaceDashboard(builder.build());
        }

        public N endNamespaceDashboard() {
             return and();
        }
    }


}
