package io.fabric8.openshift.api.model.console.v1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleNotificationSpecFluent<A extends ConsoleNotificationSpecFluent<A>> extends Fluent<A> {


    public String getBackgroundColor();
    public A withBackgroundColor(String backgroundColor);
    public Boolean hasBackgroundColor();
    public A withNewBackgroundColor(String arg1);
    public A withNewBackgroundColor(StringBuilder arg1);
    public A withNewBackgroundColor(StringBuffer arg1);
    public String getColor();
    public A withColor(String color);
    public Boolean hasColor();
    public A withNewColor(String arg1);
    public A withNewColor(StringBuilder arg1);
    public A withNewColor(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildLink instead.
 * @return The buildable object.
 */
@Deprecated public Link getLink();
    public Link buildLink();
    public A withLink(Link link);
    public Boolean hasLink();
    public A withNewLink(String href,String text);
    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLink();
    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLinkLike(Link item);
    public ConsoleNotificationSpecFluent.LinkNested<A> editLink();
    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLink();
    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLinkLike(Link item);
    public String getLocation();
    public A withLocation(String location);
    public Boolean hasLocation();
    public A withNewLocation(String arg1);
    public A withNewLocation(StringBuilder arg1);
    public A withNewLocation(StringBuffer arg1);
    public String getText();
    public A withText(String text);
    public Boolean hasText();
    public A withNewText(String arg1);
    public A withNewText(StringBuilder arg1);
    public A withNewText(StringBuffer arg1);
    public interface LinkNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LinkFluent<ConsoleNotificationSpecFluent.LinkNested<N>> {

        public N and();
        public N endLink();    }


}
