
package io.fabric8.openshift.api.model.console.v1;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "hrefTemplate",
    "namespaceFilter",
    "text"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class ConsoleExternalLogLinkSpec implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("hrefTemplate")
    private String hrefTemplate;
    /**
     * 
     * 
     */
    @JsonProperty("namespaceFilter")
    private String namespaceFilter;
    /**
     * 
     * 
     */
    @JsonProperty("text")
    private String text;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ConsoleExternalLogLinkSpec() {
    }

    /**
     * 
     * @param hrefTemplate
     * @param namespaceFilter
     * @param text
     */
    public ConsoleExternalLogLinkSpec(String hrefTemplate, String namespaceFilter, String text) {
        this.hrefTemplate = hrefTemplate;
        this.namespaceFilter = namespaceFilter;
        this.text = text;
    }

    /**
     * 
     * 
     * @return
     *     The hrefTemplate
     */
    @JsonProperty("hrefTemplate")
    public String getHrefTemplate() {
        return hrefTemplate;
    }

    /**
     * 
     * 
     * @param hrefTemplate
     *     The hrefTemplate
     */
    @JsonProperty("hrefTemplate")
    public void setHrefTemplate(String hrefTemplate) {
        this.hrefTemplate = hrefTemplate;
    }

    /**
     * 
     * 
     * @return
     *     The namespaceFilter
     */
    @JsonProperty("namespaceFilter")
    public String getNamespaceFilter() {
        return namespaceFilter;
    }

    /**
     * 
     * 
     * @param namespaceFilter
     *     The namespaceFilter
     */
    @JsonProperty("namespaceFilter")
    public void setNamespaceFilter(String namespaceFilter) {
        this.namespaceFilter = namespaceFilter;
    }

    /**
     * 
     * 
     * @return
     *     The text
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * 
     * 
     * @param text
     *     The text
     */
    @JsonProperty("text")
    public void setText(String text) {
        this.text = text;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
