package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConsoleLinkListBuilder extends ConsoleLinkListFluentImpl<ConsoleLinkListBuilder> implements VisitableBuilder<ConsoleLinkList,ConsoleLinkListBuilder> {

    ConsoleLinkListFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleLinkListBuilder() {
        this(true);
    }

    public ConsoleLinkListBuilder(Boolean validationEnabled) {
        this(new ConsoleLinkList(), validationEnabled);
    }

    public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent) {
        this(fluent, true);
    }

    public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ConsoleLinkList(), validationEnabled);
    }

    public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,ConsoleLinkList instance) {
        this(fluent, instance, true);
    }

    public ConsoleLinkListBuilder(ConsoleLinkListFluent<?> fluent,ConsoleLinkList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleLinkListBuilder(ConsoleLinkList instance) {
        this(instance,true);
    }

    public ConsoleLinkListBuilder(ConsoleLinkList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ConsoleLinkList build() {
        ConsoleLinkList buildable = new ConsoleLinkList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ConsoleLinkListBuilder that = (ConsoleLinkListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
