package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ConsoleNotificationFluent<A extends ConsoleNotificationFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ConsoleNotificationFluent.MetadataNested<A> withNewMetadata();
    public ConsoleNotificationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ConsoleNotificationFluent.MetadataNested<A> editMetadata();
    public ConsoleNotificationFluent.MetadataNested<A> editOrNewMetadata();
    public ConsoleNotificationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ConsoleNotificationSpec getSpec();
    public ConsoleNotificationSpec buildSpec();
    public A withSpec(ConsoleNotificationSpec spec);
    public Boolean hasSpec();
    public ConsoleNotificationFluent.SpecNested<A> withNewSpec();
    public ConsoleNotificationFluent.SpecNested<A> withNewSpecLike(ConsoleNotificationSpec item);
    public ConsoleNotificationFluent.SpecNested<A> editSpec();
    public ConsoleNotificationFluent.SpecNested<A> editOrNewSpec();
    public ConsoleNotificationFluent.SpecNested<A> editOrNewSpecLike(ConsoleNotificationSpec item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ConsoleNotificationFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConsoleNotificationSpecFluent<ConsoleNotificationFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


}
