package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LinkBuilder extends LinkFluentImpl<LinkBuilder> implements VisitableBuilder<Link,LinkBuilder> {

    LinkFluent<?> fluent;
    Boolean validationEnabled;

    public LinkBuilder() {
        this(true);
    }

    public LinkBuilder(Boolean validationEnabled) {
        this(new Link(), validationEnabled);
    }

    public LinkBuilder(LinkFluent<?> fluent) {
        this(fluent, true);
    }

    public LinkBuilder(LinkFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Link(), validationEnabled);
    }

    public LinkBuilder(LinkFluent<?> fluent,Link instance) {
        this(fluent, instance, true);
    }

    public LinkBuilder(LinkFluent<?> fluent,Link instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withHref(instance.getHref()); 
        fluent.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public LinkBuilder(Link instance) {
        this(instance,true);
    }

    public LinkBuilder(Link instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withHref(instance.getHref()); 
        this.withText(instance.getText()); 
        this.validationEnabled = validationEnabled; 
    }

    public Link build() {
        Link buildable = new Link(fluent.getHref(),fluent.getText());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LinkBuilder that = (LinkBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
