/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLink;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLinkBuilder;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLinkFluentImpl;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConsoleCLIDownloadSpecFluentImpl<A extends ConsoleCLIDownloadSpecFluent<A>>
extends BaseFluent<A>
implements ConsoleCLIDownloadSpecFluent<A> {
    private String description;
    private String displayName;
    private List<CLIDownloadLinkBuilder> links = new ArrayList<CLIDownloadLinkBuilder>();

    public ConsoleCLIDownloadSpecFluentImpl() {
    }

    public ConsoleCLIDownloadSpecFluentImpl(ConsoleCLIDownloadSpec instance) {
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withLinks(instance.getLinks());
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    @Deprecated
    public A withNewDescription(String arg0) {
        return this.withDescription(new String(arg0));
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    @Override
    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Override
    @Deprecated
    public A withNewDisplayName(String arg0) {
        return this.withDisplayName(new String(arg0));
    }

    @Override
    public A addToLinks(Integer index, CLIDownloadLink item) {
        if (this.links == null) {
            this.links = new ArrayList<CLIDownloadLinkBuilder>();
        }
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
        this._visitables.get((Object)"links").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"links").size(), builder);
        this.links.add(index >= 0 ? index.intValue() : this.links.size(), builder);
        return (A)this;
    }

    @Override
    public A setToLinks(Integer index, CLIDownloadLink item) {
        if (this.links == null) {
            this.links = new ArrayList<CLIDownloadLinkBuilder>();
        }
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"links").size()) {
            this._visitables.get((Object)"links").add(builder);
        } else {
            this._visitables.get((Object)"links").set(index, builder);
        }
        if (index < 0 || index >= this.links.size()) {
            this.links.add(builder);
        } else {
            this.links.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToLinks(CLIDownloadLink ... items) {
        if (this.links == null) {
            this.links = new ArrayList<CLIDownloadLinkBuilder>();
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToLinks(Collection<CLIDownloadLink> items) {
        if (this.links == null) {
            this.links = new ArrayList<CLIDownloadLinkBuilder>();
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromLinks(CLIDownloadLink ... items) {
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromLinks(Collection<CLIDownloadLink> items) {
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").remove(builder);
            if (this.links == null) continue;
            this.links.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromLinks(Predicate<CLIDownloadLinkBuilder> predicate) {
        if (this.links == null) {
            return (A)this;
        }
        Iterator<CLIDownloadLinkBuilder> each = this.links.iterator();
        List visitables = this._visitables.get((Object)"links");
        while (each.hasNext()) {
            CLIDownloadLinkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CLIDownloadLink> getLinks() {
        return ConsoleCLIDownloadSpecFluentImpl.build(this.links);
    }

    @Override
    public List<CLIDownloadLink> buildLinks() {
        return ConsoleCLIDownloadSpecFluentImpl.build(this.links);
    }

    @Override
    public CLIDownloadLink buildLink(Integer index) {
        return this.links.get(index).build();
    }

    @Override
    public CLIDownloadLink buildFirstLink() {
        return this.links.get(0).build();
    }

    @Override
    public CLIDownloadLink buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    @Override
    public CLIDownloadLink buildMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withLinks(List<CLIDownloadLink> links) {
        if (this.links != null) {
            this._visitables.get((Object)"links").removeAll(this.links);
        }
        if (links != null) {
            this.links = new ArrayList<CLIDownloadLinkBuilder>();
            for (CLIDownloadLink item : links) {
                this.addToLinks(item);
            }
        } else {
            this.links = null;
        }
        return (A)this;
    }

    @Override
    public A withLinks(CLIDownloadLink ... links) {
        if (this.links != null) {
            this.links.clear();
        }
        if (links != null) {
            for (CLIDownloadLink item : links) {
                this.addToLinks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    @Override
    public A addNewLink(String href, String text) {
        return this.addToLinks(new CLIDownloadLink(href, text));
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> addNewLink() {
        return new LinksNestedImpl();
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> addNewLinkLike(CLIDownloadLink item) {
        return new LinksNestedImpl(-1, item);
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> setNewLinkLike(Integer index, CLIDownloadLink item) {
        return new LinksNestedImpl(index, item);
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editLink(Integer index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    @Override
    public ConsoleCLIDownloadSpecFluent.LinksNested<A> editMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.test(this.links.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleCLIDownloadSpecFluentImpl that = (ConsoleCLIDownloadSpecFluentImpl)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        return !(this.links != null ? !this.links.equals(that.links) : that.links != null);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.displayName, this.links, super.hashCode());
    }

    public class LinksNestedImpl<N>
    extends CLIDownloadLinkFluentImpl<ConsoleCLIDownloadSpecFluent.LinksNested<N>>
    implements ConsoleCLIDownloadSpecFluent.LinksNested<N>,
    Nested<N> {
        CLIDownloadLinkBuilder builder;
        Integer index;

        LinksNestedImpl(Integer index, CLIDownloadLink item) {
            this.index = index;
            this.builder = new CLIDownloadLinkBuilder(this, item);
        }

        LinksNestedImpl() {
            this.index = -1;
            this.builder = new CLIDownloadLinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleCLIDownloadSpecFluentImpl.this.setToLinks(this.index, this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }
}

