package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ConsoleNotificationSpecBuilder extends io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluentImpl<io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecBuilder>{
  public ConsoleNotificationSpecBuilder() {
    this(false);
  }
  public ConsoleNotificationSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ConsoleNotificationSpec(), validationEnabled);
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleNotificationSpec(), validationEnabled);
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent<?> fluent,io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackgroundColor(instance.getBackgroundColor()); 
    fluent.withColor(instance.getColor()); 
    fluent.withLink(instance.getLink()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withText(instance.getText()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec instance) {
    this(instance,false);
  }
  public ConsoleNotificationSpecBuilder(io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackgroundColor(instance.getBackgroundColor()); 
    this.withColor(instance.getColor()); 
    this.withLink(instance.getLink()); 
    this.withLocation(instance.getLocation()); 
    this.withText(instance.getText()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec build() {
    ConsoleNotificationSpec buildable = new ConsoleNotificationSpec(fluent.getBackgroundColor(),fluent.getColor(),fluent.getLink(),fluent.getLocation(),fluent.getText());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleNotificationSpecBuilder that = (ConsoleNotificationSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}