/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLink;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLinkBuilder;
import io.fabric8.openshift.api.model.console.v1.CLIDownloadLinkFluent;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ConsoleCLIDownloadSpecFluent<A extends ConsoleCLIDownloadSpecFluent<A>>
extends BaseFluent<A> {
    private String description;
    private String displayName;
    private ArrayList<CLIDownloadLinkBuilder> links = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ConsoleCLIDownloadSpecFluent() {
    }

    public ConsoleCLIDownloadSpecFluent(ConsoleCLIDownloadSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConsoleCLIDownloadSpec instance) {
        ConsoleCLIDownloadSpec consoleCLIDownloadSpec = instance = instance != null ? instance : new ConsoleCLIDownloadSpec();
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withDisplayName(instance.getDisplayName());
            this.withLinks(instance.getLinks());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description = description;
        return (A)((Object)this);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)((Object)this);
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A addToLinks(int index, CLIDownloadLink item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get((Object)"links").add(index, builder);
            this.links.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToLinks(int index, CLIDownloadLink item) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
        if (index < 0 || index >= this.links.size()) {
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        } else {
            this._visitables.get((Object)"links").set(index, builder);
            this.links.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToLinks(CLIDownloadLink ... items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLinks(Collection<CLIDownloadLink> items) {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").add(builder);
            this.links.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromLinks(CLIDownloadLink ... items) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").remove((Object)builder);
            this.links.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLinks(Collection<CLIDownloadLink> items) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        for (CLIDownloadLink item : items) {
            CLIDownloadLinkBuilder builder = new CLIDownloadLinkBuilder(item);
            this._visitables.get((Object)"links").remove((Object)builder);
            this.links.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLinks(Predicate<CLIDownloadLinkBuilder> predicate) {
        if (this.links == null) {
            return (A)((Object)this);
        }
        Iterator<CLIDownloadLinkBuilder> each = this.links.iterator();
        List visitables = this._visitables.get((Object)"links");
        while (each.hasNext()) {
            CLIDownloadLinkBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CLIDownloadLink> buildLinks() {
        return this.links != null ? ConsoleCLIDownloadSpecFluent.build(this.links) : null;
    }

    public CLIDownloadLink buildLink(int index) {
        return this.links.get(index).build();
    }

    public CLIDownloadLink buildFirstLink() {
        return this.links.get(0).build();
    }

    public CLIDownloadLink buildLastLink() {
        return this.links.get(this.links.size() - 1).build();
    }

    public CLIDownloadLink buildMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        for (CLIDownloadLinkBuilder item : this.links) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLinks(List<CLIDownloadLink> links) {
        if (this.links != null) {
            this._visitables.get((Object)"links").clear();
        }
        if (links != null) {
            this.links = new ArrayList();
            for (CLIDownloadLink item : links) {
                this.addToLinks(item);
            }
        } else {
            this.links = null;
        }
        return (A)((Object)this);
    }

    public A withLinks(CLIDownloadLink ... links) {
        if (this.links != null) {
            this.links.clear();
            this._visitables.remove((Object)"links");
        }
        if (links != null) {
            for (CLIDownloadLink item : links) {
                this.addToLinks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public A addNewLink(String href, String text) {
        return this.addToLinks(new CLIDownloadLink(href, text));
    }

    public LinksNested<A> addNewLink() {
        return new LinksNested(-1, null);
    }

    public LinksNested<A> addNewLinkLike(CLIDownloadLink item) {
        return new LinksNested(-1, item);
    }

    public LinksNested<A> setNewLinkLike(int index, CLIDownloadLink item) {
        return new LinksNested(index, item);
    }

    public LinksNested<A> editLink(int index) {
        if (this.links.size() <= index) {
            throw new RuntimeException("Can't edit links. Index exceeds size.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editFirstLink() {
        if (this.links.size() == 0) {
            throw new RuntimeException("Can't edit first links. The list is empty.");
        }
        return this.setNewLinkLike(0, this.buildLink(0));
    }

    public LinksNested<A> editLastLink() {
        int index = this.links.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last links. The list is empty.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public LinksNested<A> editMatchingLink(Predicate<CLIDownloadLinkBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.links.size(); ++i) {
            if (!predicate.test(this.links.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching links. No match found.");
        }
        return this.setNewLinkLike(index, this.buildLink(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleCLIDownloadSpecFluent that = (ConsoleCLIDownloadSpecFluent)((Object)o);
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.displayName, that.displayName)) {
            return false;
        }
        if (!Objects.equals(this.links, that.links)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.displayName, this.links, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.displayName != null) {
            sb.append("displayName:");
            sb.append(this.displayName + ",");
        }
        if (this.links != null && !this.links.isEmpty()) {
            sb.append("links:");
            sb.append(this.links + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LinksNested<N>
    extends CLIDownloadLinkFluent<LinksNested<N>>
    implements Nested<N> {
        CLIDownloadLinkBuilder builder;
        int index;

        LinksNested(int index, CLIDownloadLink item) {
            this.index = index;
            this.builder = new CLIDownloadLinkBuilder(this, item);
        }

        public N and() {
            return (N)ConsoleCLIDownloadSpecFluent.this.setToLinks(this.index, this.builder.build());
        }

        public N endLink() {
            return this.and();
        }
    }
}

