package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleLinkBuilder extends ConsoleLinkFluentImpl<ConsoleLinkBuilder> implements VisitableBuilder<ConsoleLink,ConsoleLinkBuilder>{
  public ConsoleLinkBuilder() {
    this(false);
  }
  public ConsoleLinkBuilder(Boolean validationEnabled) {
    this(new ConsoleLink(), validationEnabled);
  }
  public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleLink(), validationEnabled);
  }
  public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,ConsoleLink instance) {
    this(fluent, instance, false);
  }
  public ConsoleLinkBuilder(ConsoleLinkFluent<?> fluent,ConsoleLink instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleLinkBuilder(ConsoleLink instance) {
    this(instance,false);
  }
  public ConsoleLinkBuilder(ConsoleLink instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleLinkFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleLink build() {
    ConsoleLink buildable = new ConsoleLink(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}