package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleNotificationSpecBuilder extends ConsoleNotificationSpecFluentImpl<ConsoleNotificationSpecBuilder> implements VisitableBuilder<ConsoleNotificationSpec,ConsoleNotificationSpecBuilder>{
  public ConsoleNotificationSpecBuilder() {
    this(false);
  }
  public ConsoleNotificationSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleNotificationSpec(), validationEnabled);
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleNotificationSpec(), validationEnabled);
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,ConsoleNotificationSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpecFluent<?> fluent,ConsoleNotificationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackgroundColor(instance.getBackgroundColor()); 
    fluent.withColor(instance.getColor()); 
    fluent.withLink(instance.getLink()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withText(instance.getText()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpec instance) {
    this(instance,false);
  }
  public ConsoleNotificationSpecBuilder(ConsoleNotificationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackgroundColor(instance.getBackgroundColor()); 
    this.withColor(instance.getColor()); 
    this.withLink(instance.getLink()); 
    this.withLocation(instance.getLocation()); 
    this.withText(instance.getText()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConsoleNotificationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleNotificationSpec build() {
    ConsoleNotificationSpec buildable = new ConsoleNotificationSpec(fluent.getBackgroundColor(),fluent.getColor(),fluent.getLink(),fluent.getLocation(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}