package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ApplicationMenuSpecBuilder extends ApplicationMenuSpecFluentImpl<ApplicationMenuSpecBuilder> implements VisitableBuilder<ApplicationMenuSpec,ApplicationMenuSpecBuilder>{
  public ApplicationMenuSpecBuilder() {
    this(false);
  }
  public ApplicationMenuSpecBuilder(Boolean validationEnabled) {
    this(new ApplicationMenuSpec(), validationEnabled);
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ApplicationMenuSpec(), validationEnabled);
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,ApplicationMenuSpec instance) {
    this(fluent, instance, false);
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpecFluent<?> fluent,ApplicationMenuSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageURL(instance.getImageURL()); 
    fluent.withSection(instance.getSection()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpec instance) {
    this(instance,false);
  }
  public ApplicationMenuSpecBuilder(ApplicationMenuSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageURL(instance.getImageURL()); 
    this.withSection(instance.getSection()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ApplicationMenuSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ApplicationMenuSpec build() {
    ApplicationMenuSpec buildable = new ApplicationMenuSpec(fluent.getImageURL(),fluent.getSection());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}