/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluent;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReview;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReviewBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskReviewFluentImpl;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummary;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummaryBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskSummaryFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConsoleQuickStartTaskFluentImpl<A extends ConsoleQuickStartTaskFluent<A>>
extends BaseFluent<A>
implements ConsoleQuickStartTaskFluent<A> {
    private String description;
    private ConsoleQuickStartTaskReviewBuilder review;
    private ConsoleQuickStartTaskSummaryBuilder summary;
    private String title;
    private Map<String, Object> additionalProperties;

    public ConsoleQuickStartTaskFluentImpl() {
    }

    public ConsoleQuickStartTaskFluentImpl(ConsoleQuickStartTask instance) {
        if (instance != null) {
            this.withDescription(instance.getDescription());
            this.withReview(instance.getReview());
            this.withSummary(instance.getSummary());
            this.withTitle(instance.getTitle());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    @Deprecated
    public ConsoleQuickStartTaskReview getReview() {
        return this.review != null ? this.review.build() : null;
    }

    @Override
    public ConsoleQuickStartTaskReview buildReview() {
        return this.review != null ? this.review.build() : null;
    }

    @Override
    public A withReview(ConsoleQuickStartTaskReview review) {
        this._visitables.get((Object)"review").remove(this.review);
        if (review != null) {
            this.review = new ConsoleQuickStartTaskReviewBuilder(review);
            this._visitables.get((Object)"review").add(this.review);
        } else {
            this.review = null;
            this._visitables.get((Object)"review").remove(this.review);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReview() {
        return this.review != null;
    }

    @Override
    public A withNewReview(String failedTaskHelp, String instructions) {
        return this.withReview(new ConsoleQuickStartTaskReview(failedTaskHelp, instructions));
    }

    @Override
    public ConsoleQuickStartTaskFluent.ReviewNested<A> withNewReview() {
        return new ReviewNestedImpl();
    }

    @Override
    public ConsoleQuickStartTaskFluent.ReviewNested<A> withNewReviewLike(ConsoleQuickStartTaskReview item) {
        return new ReviewNestedImpl(item);
    }

    @Override
    public ConsoleQuickStartTaskFluent.ReviewNested<A> editReview() {
        return this.withNewReviewLike(this.getReview());
    }

    @Override
    public ConsoleQuickStartTaskFluent.ReviewNested<A> editOrNewReview() {
        return this.withNewReviewLike(this.getReview() != null ? this.getReview() : new ConsoleQuickStartTaskReviewBuilder().build());
    }

    @Override
    public ConsoleQuickStartTaskFluent.ReviewNested<A> editOrNewReviewLike(ConsoleQuickStartTaskReview item) {
        return this.withNewReviewLike(this.getReview() != null ? this.getReview() : item);
    }

    @Override
    @Deprecated
    public ConsoleQuickStartTaskSummary getSummary() {
        return this.summary != null ? this.summary.build() : null;
    }

    @Override
    public ConsoleQuickStartTaskSummary buildSummary() {
        return this.summary != null ? this.summary.build() : null;
    }

    @Override
    public A withSummary(ConsoleQuickStartTaskSummary summary) {
        this._visitables.get((Object)"summary").remove(this.summary);
        if (summary != null) {
            this.summary = new ConsoleQuickStartTaskSummaryBuilder(summary);
            this._visitables.get((Object)"summary").add(this.summary);
        } else {
            this.summary = null;
            this._visitables.get((Object)"summary").remove(this.summary);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSummary() {
        return this.summary != null;
    }

    @Override
    public A withNewSummary(String failed, String success) {
        return this.withSummary(new ConsoleQuickStartTaskSummary(failed, success));
    }

    @Override
    public ConsoleQuickStartTaskFluent.SummaryNested<A> withNewSummary() {
        return new SummaryNestedImpl();
    }

    @Override
    public ConsoleQuickStartTaskFluent.SummaryNested<A> withNewSummaryLike(ConsoleQuickStartTaskSummary item) {
        return new SummaryNestedImpl(item);
    }

    @Override
    public ConsoleQuickStartTaskFluent.SummaryNested<A> editSummary() {
        return this.withNewSummaryLike(this.getSummary());
    }

    @Override
    public ConsoleQuickStartTaskFluent.SummaryNested<A> editOrNewSummary() {
        return this.withNewSummaryLike(this.getSummary() != null ? this.getSummary() : new ConsoleQuickStartTaskSummaryBuilder().build());
    }

    @Override
    public ConsoleQuickStartTaskFluent.SummaryNested<A> editOrNewSummaryLike(ConsoleQuickStartTaskSummary item) {
        return this.withNewSummaryLike(this.getSummary() != null ? this.getSummary() : item);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public A withTitle(String title) {
        this.title = title;
        return (A)this;
    }

    @Override
    public Boolean hasTitle() {
        return this.title != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleQuickStartTaskFluentImpl that = (ConsoleQuickStartTaskFluentImpl)o;
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.review, that.review)) {
            return false;
        }
        if (!Objects.equals(this.summary, that.summary)) {
            return false;
        }
        if (!Objects.equals(this.title, that.title)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.review, this.summary, this.title, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description != null) {
            sb.append("description:");
            sb.append(this.description + ",");
        }
        if (this.review != null) {
            sb.append("review:");
            sb.append(this.review + ",");
        }
        if (this.summary != null) {
            sb.append("summary:");
            sb.append(this.summary + ",");
        }
        if (this.title != null) {
            sb.append("title:");
            sb.append(this.title + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SummaryNestedImpl<N>
    extends ConsoleQuickStartTaskSummaryFluentImpl<ConsoleQuickStartTaskFluent.SummaryNested<N>>
    implements ConsoleQuickStartTaskFluent.SummaryNested<N>,
    Nested<N> {
        ConsoleQuickStartTaskSummaryBuilder builder;

        SummaryNestedImpl(ConsoleQuickStartTaskSummary item) {
            this.builder = new ConsoleQuickStartTaskSummaryBuilder(this, item);
        }

        SummaryNestedImpl() {
            this.builder = new ConsoleQuickStartTaskSummaryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleQuickStartTaskFluentImpl.this.withSummary(this.builder.build());
        }

        @Override
        public N endSummary() {
            return this.and();
        }
    }

    class ReviewNestedImpl<N>
    extends ConsoleQuickStartTaskReviewFluentImpl<ConsoleQuickStartTaskFluent.ReviewNested<N>>
    implements ConsoleQuickStartTaskFluent.ReviewNested<N>,
    Nested<N> {
        ConsoleQuickStartTaskReviewBuilder builder;

        ReviewNestedImpl(ConsoleQuickStartTaskReview item) {
            this.builder = new ConsoleQuickStartTaskReviewBuilder(this, item);
        }

        ReviewNestedImpl() {
            this.builder = new ConsoleQuickStartTaskReviewBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleQuickStartTaskFluentImpl.this.withReview(this.builder.build());
        }

        @Override
        public N endReview() {
            return this.and();
        }
    }
}

