package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleCLIDownloadBuilder extends ConsoleCLIDownloadFluent<ConsoleCLIDownloadBuilder> implements VisitableBuilder<ConsoleCLIDownload,ConsoleCLIDownloadBuilder>{
  public ConsoleCLIDownloadBuilder() {
    this(false);
  }
  public ConsoleCLIDownloadBuilder(Boolean validationEnabled) {
    this(new ConsoleCLIDownload(), validationEnabled);
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownloadFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownloadFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleCLIDownload(), validationEnabled);
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownloadFluent<?> fluent,ConsoleCLIDownload instance) {
    this(fluent, instance, false);
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownloadFluent<?> fluent,ConsoleCLIDownload instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleCLIDownload());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownload instance) {
    this(instance,false);
  }
  public ConsoleCLIDownloadBuilder(ConsoleCLIDownload instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleCLIDownload());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleCLIDownloadFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleCLIDownload build() {
    ConsoleCLIDownload buildable = new ConsoleCLIDownload(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}