package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleCLIDownloadSpecBuilder extends ConsoleCLIDownloadSpecFluent<ConsoleCLIDownloadSpecBuilder> implements VisitableBuilder<ConsoleCLIDownloadSpec,ConsoleCLIDownloadSpecBuilder>{
  public ConsoleCLIDownloadSpecBuilder() {
    this(false);
  }
  public ConsoleCLIDownloadSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleCLIDownloadSpec(), validationEnabled);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleCLIDownloadSpec(), validationEnabled);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,ConsoleCLIDownloadSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpecFluent<?> fluent,ConsoleCLIDownloadSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleCLIDownloadSpec());

    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withLinks(instance.getLinks());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withLinks(instance.getLinks());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpec instance) {
    this(instance,false);
  }
  public ConsoleCLIDownloadSpecBuilder(ConsoleCLIDownloadSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleCLIDownloadSpec());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withLinks(instance.getLinks());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withLinks(instance.getLinks());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleCLIDownloadSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleCLIDownloadSpec build() {
    ConsoleCLIDownloadSpec buildable = new ConsoleCLIDownloadSpec(fluent.getDescription(),fluent.getDisplayName(),fluent.buildLinks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}