package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConsoleLinkSpecFluent<A extends ConsoleLinkSpecFluent<A>> extends BaseFluent<A>{
  public ConsoleLinkSpecFluent() {
  }
  public ConsoleLinkSpecFluent(ConsoleLinkSpec instance) {
    instance = (instance != null ? instance : new ConsoleLinkSpec());

    if (instance != null) {
      this.withApplicationMenu(instance.getApplicationMenu());
      this.withHref(instance.getHref());
      this.withLocation(instance.getLocation());
      this.withNamespaceDashboard(instance.getNamespaceDashboard());
      this.withText(instance.getText());
      this.withApplicationMenu(instance.getApplicationMenu());
      this.withHref(instance.getHref());
      this.withLocation(instance.getLocation());
      this.withNamespaceDashboard(instance.getNamespaceDashboard());
      this.withText(instance.getText());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ApplicationMenuSpecBuilder applicationMenu;
  private String href;
  private String location;
  private NamespaceDashboardSpecBuilder namespaceDashboard;
  private String text;
  private Map<String,Object> additionalProperties;
  public ApplicationMenuSpec buildApplicationMenu() {
    return this.applicationMenu!=null ?this.applicationMenu.build():null;
  }
  public A withApplicationMenu(ApplicationMenuSpec applicationMenu) {
    _visitables.get("applicationMenu").remove(this.applicationMenu);
    if (applicationMenu!=null){ this.applicationMenu= new ApplicationMenuSpecBuilder(applicationMenu); _visitables.get("applicationMenu").add(this.applicationMenu);} else { this.applicationMenu = null; _visitables.get("applicationMenu").remove(this.applicationMenu); } return (A) this;
  }
  public boolean hasApplicationMenu() {
    return this.applicationMenu != null;
  }
  public A withNewApplicationMenu(String imageURL,String section) {
    return (A)withApplicationMenu(new ApplicationMenuSpec(imageURL, section));
  }
  public ApplicationMenuNested<A> withNewApplicationMenu() {
    return new ApplicationMenuNested(null);
  }
  public ApplicationMenuNested<A> withNewApplicationMenuLike(ApplicationMenuSpec item) {
    return new ApplicationMenuNested(item);
  }
  public ApplicationMenuNested<A> editApplicationMenu() {
    return withNewApplicationMenuLike(java.util.Optional.ofNullable(buildApplicationMenu()).orElse(null));
  }
  public ApplicationMenuNested<A> editOrNewApplicationMenu() {
    return withNewApplicationMenuLike(java.util.Optional.ofNullable(buildApplicationMenu()).orElse(new ApplicationMenuSpecBuilder().build()));
  }
  public ApplicationMenuNested<A> editOrNewApplicationMenuLike(ApplicationMenuSpec item) {
    return withNewApplicationMenuLike(java.util.Optional.ofNullable(buildApplicationMenu()).orElse(item));
  }
  public String getHref() {
    return this.href;
  }
  public A withHref(String href) {
    this.href=href; return (A) this;
  }
  public boolean hasHref() {
    return this.href != null;
  }
  public String getLocation() {
    return this.location;
  }
  public A withLocation(String location) {
    this.location=location; return (A) this;
  }
  public boolean hasLocation() {
    return this.location != null;
  }
  public NamespaceDashboardSpec buildNamespaceDashboard() {
    return this.namespaceDashboard!=null ?this.namespaceDashboard.build():null;
  }
  public A withNamespaceDashboard(NamespaceDashboardSpec namespaceDashboard) {
    _visitables.get("namespaceDashboard").remove(this.namespaceDashboard);
    if (namespaceDashboard!=null){ this.namespaceDashboard= new NamespaceDashboardSpecBuilder(namespaceDashboard); _visitables.get("namespaceDashboard").add(this.namespaceDashboard);} else { this.namespaceDashboard = null; _visitables.get("namespaceDashboard").remove(this.namespaceDashboard); } return (A) this;
  }
  public boolean hasNamespaceDashboard() {
    return this.namespaceDashboard != null;
  }
  public NamespaceDashboardNested<A> withNewNamespaceDashboard() {
    return new NamespaceDashboardNested(null);
  }
  public NamespaceDashboardNested<A> withNewNamespaceDashboardLike(NamespaceDashboardSpec item) {
    return new NamespaceDashboardNested(item);
  }
  public NamespaceDashboardNested<A> editNamespaceDashboard() {
    return withNewNamespaceDashboardLike(java.util.Optional.ofNullable(buildNamespaceDashboard()).orElse(null));
  }
  public NamespaceDashboardNested<A> editOrNewNamespaceDashboard() {
    return withNewNamespaceDashboardLike(java.util.Optional.ofNullable(buildNamespaceDashboard()).orElse(new NamespaceDashboardSpecBuilder().build()));
  }
  public NamespaceDashboardNested<A> editOrNewNamespaceDashboardLike(NamespaceDashboardSpec item) {
    return withNewNamespaceDashboardLike(java.util.Optional.ofNullable(buildNamespaceDashboard()).orElse(item));
  }
  public String getText() {
    return this.text;
  }
  public A withText(String text) {
    this.text=text; return (A) this;
  }
  public boolean hasText() {
    return this.text != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleLinkSpecFluent that = (ConsoleLinkSpecFluent) o;
    if (!java.util.Objects.equals(applicationMenu, that.applicationMenu)) return false;

    if (!java.util.Objects.equals(href, that.href)) return false;

    if (!java.util.Objects.equals(location, that.location)) return false;

    if (!java.util.Objects.equals(namespaceDashboard, that.namespaceDashboard)) return false;

    if (!java.util.Objects.equals(text, that.text)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(applicationMenu,  href,  location,  namespaceDashboard,  text,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (applicationMenu != null) { sb.append("applicationMenu:"); sb.append(applicationMenu + ","); }
    if (href != null) { sb.append("href:"); sb.append(href + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (namespaceDashboard != null) { sb.append("namespaceDashboard:"); sb.append(namespaceDashboard + ","); }
    if (text != null) { sb.append("text:"); sb.append(text + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApplicationMenuNested<N> extends ApplicationMenuSpecFluent<ApplicationMenuNested<N>> implements Nested<N>{
    ApplicationMenuNested(ApplicationMenuSpec item) {
      this.builder = new ApplicationMenuSpecBuilder(this, item);
    }
    ApplicationMenuSpecBuilder builder;
    public N and() {
      return (N) ConsoleLinkSpecFluent.this.withApplicationMenu(builder.build());
    }
    public N endApplicationMenu() {
      return and();
    }
    
  }
  public class NamespaceDashboardNested<N> extends NamespaceDashboardSpecFluent<NamespaceDashboardNested<N>> implements Nested<N>{
    NamespaceDashboardNested(NamespaceDashboardSpec item) {
      this.builder = new NamespaceDashboardSpecBuilder(this, item);
    }
    NamespaceDashboardSpecBuilder builder;
    public N and() {
      return (N) ConsoleLinkSpecFluent.this.withNamespaceDashboard(builder.build());
    }
    public N endNamespaceDashboard() {
      return and();
    }
    
  }
  
}