package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleNotificationListBuilder extends ConsoleNotificationListFluent<ConsoleNotificationListBuilder> implements VisitableBuilder<ConsoleNotificationList,ConsoleNotificationListBuilder>{
  public ConsoleNotificationListBuilder() {
    this(false);
  }
  public ConsoleNotificationListBuilder(Boolean validationEnabled) {
    this(new ConsoleNotificationList(), validationEnabled);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleNotificationList(), validationEnabled);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,ConsoleNotificationList instance) {
    this(fluent, instance, false);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationListFluent<?> fluent,ConsoleNotificationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleNotificationList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationList instance) {
    this(instance,false);
  }
  public ConsoleNotificationListBuilder(ConsoleNotificationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleNotificationList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleNotificationListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleNotificationList build() {
    ConsoleNotificationList buildable = new ConsoleNotificationList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}