package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartListBuilder extends ConsoleQuickStartListFluent<ConsoleQuickStartListBuilder> implements VisitableBuilder<ConsoleQuickStartList,ConsoleQuickStartListBuilder>{
  public ConsoleQuickStartListBuilder() {
    this(false);
  }
  public ConsoleQuickStartListBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStartList(), validationEnabled);
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartListFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStartList(), validationEnabled);
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartListFluent<?> fluent,ConsoleQuickStartList instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartListFluent<?> fluent,ConsoleQuickStartList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleQuickStartList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartList instance) {
    this(instance,false);
  }
  public ConsoleQuickStartListBuilder(ConsoleQuickStartList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleQuickStartList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleQuickStartListFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleQuickStartList build() {
    ConsoleQuickStartList buildable = new ConsoleQuickStartList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}