package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartTaskReviewBuilder extends ConsoleQuickStartTaskReviewFluent<ConsoleQuickStartTaskReviewBuilder> implements VisitableBuilder<ConsoleQuickStartTaskReview,ConsoleQuickStartTaskReviewBuilder>{
  public ConsoleQuickStartTaskReviewBuilder() {
    this(false);
  }
  public ConsoleQuickStartTaskReviewBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStartTaskReview(), validationEnabled);
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStartTaskReview(), validationEnabled);
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReviewFluent<?> fluent,ConsoleQuickStartTaskReview instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReviewFluent<?> fluent,ConsoleQuickStartTaskReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleQuickStartTaskReview());

    if (instance != null) {
      fluent.withFailedTaskHelp(instance.getFailedTaskHelp());
      fluent.withInstructions(instance.getInstructions());
      fluent.withFailedTaskHelp(instance.getFailedTaskHelp());
      fluent.withInstructions(instance.getInstructions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReview instance) {
    this(instance,false);
  }
  public ConsoleQuickStartTaskReviewBuilder(ConsoleQuickStartTaskReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleQuickStartTaskReview());

    if (instance != null) {
      this.withFailedTaskHelp(instance.getFailedTaskHelp());
      this.withInstructions(instance.getInstructions());
      this.withFailedTaskHelp(instance.getFailedTaskHelp());
      this.withInstructions(instance.getInstructions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleQuickStartTaskReviewFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleQuickStartTaskReview build() {
    ConsoleQuickStartTaskReview buildable = new ConsoleQuickStartTaskReview(fluent.getFailedTaskHelp(),fluent.getInstructions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}