package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleQuickStartTaskSummaryBuilder extends ConsoleQuickStartTaskSummaryFluent<ConsoleQuickStartTaskSummaryBuilder> implements VisitableBuilder<ConsoleQuickStartTaskSummary,ConsoleQuickStartTaskSummaryBuilder>{
  public ConsoleQuickStartTaskSummaryBuilder() {
    this(false);
  }
  public ConsoleQuickStartTaskSummaryBuilder(Boolean validationEnabled) {
    this(new ConsoleQuickStartTaskSummary(), validationEnabled);
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummaryFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummaryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsoleQuickStartTaskSummary(), validationEnabled);
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummaryFluent<?> fluent,ConsoleQuickStartTaskSummary instance) {
    this(fluent, instance, false);
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummaryFluent<?> fluent,ConsoleQuickStartTaskSummary instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsoleQuickStartTaskSummary());

    if (instance != null) {
      fluent.withFailed(instance.getFailed());
      fluent.withSuccess(instance.getSuccess());
      fluent.withFailed(instance.getFailed());
      fluent.withSuccess(instance.getSuccess());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummary instance) {
    this(instance,false);
  }
  public ConsoleQuickStartTaskSummaryBuilder(ConsoleQuickStartTaskSummary instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsoleQuickStartTaskSummary());

    if (instance != null) {
      this.withFailed(instance.getFailed());
      this.withSuccess(instance.getSuccess());
      this.withFailed(instance.getFailed());
      this.withSuccess(instance.getSuccess());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsoleQuickStartTaskSummaryFluent<?> fluent;
  Boolean validationEnabled;
  public ConsoleQuickStartTaskSummary build() {
    ConsoleQuickStartTaskSummary buildable = new ConsoleQuickStartTaskSummary(fluent.getFailed(),fluent.getSuccess());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}