package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginProxyBuilder extends ConsolePluginProxyFluent<ConsolePluginProxyBuilder> implements VisitableBuilder<ConsolePluginProxy,ConsolePluginProxyBuilder>{
  public ConsolePluginProxyBuilder() {
    this(false);
  }
  public ConsolePluginProxyBuilder(Boolean validationEnabled) {
    this(new ConsolePluginProxy(), validationEnabled);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginProxy(), validationEnabled);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,ConsolePluginProxy instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxyFluent<?> fluent,ConsolePluginProxy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsolePluginProxy());

    if (instance != null) {
      fluent.withAlias(instance.getAlias());
      fluent.withAuthorize(instance.getAuthorize());
      fluent.withCaCertificate(instance.getCaCertificate());
      fluent.withService(instance.getService());
      fluent.withType(instance.getType());
      fluent.withAlias(instance.getAlias());
      fluent.withAuthorize(instance.getAuthorize());
      fluent.withCaCertificate(instance.getCaCertificate());
      fluent.withService(instance.getService());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxy instance) {
    this(instance,false);
  }
  public ConsolePluginProxyBuilder(ConsolePluginProxy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsolePluginProxy());

    if (instance != null) {
      this.withAlias(instance.getAlias());
      this.withAuthorize(instance.getAuthorize());
      this.withCaCertificate(instance.getCaCertificate());
      this.withService(instance.getService());
      this.withType(instance.getType());
      this.withAlias(instance.getAlias());
      this.withAuthorize(instance.getAuthorize());
      this.withCaCertificate(instance.getCaCertificate());
      this.withService(instance.getService());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginProxyFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginProxy build() {
    ConsolePluginProxy buildable = new ConsolePluginProxy(fluent.getAlias(),fluent.getAuthorize(),fluent.getCaCertificate(),fluent.buildService(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}