package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginProxyServiceConfigBuilder extends ConsolePluginProxyServiceConfigFluent<ConsolePluginProxyServiceConfigBuilder> implements VisitableBuilder<ConsolePluginProxyServiceConfig,ConsolePluginProxyServiceConfigBuilder>{
  public ConsolePluginProxyServiceConfigBuilder() {
    this(false);
  }
  public ConsolePluginProxyServiceConfigBuilder(Boolean validationEnabled) {
    this(new ConsolePluginProxyServiceConfig(), validationEnabled);
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginProxyServiceConfig(), validationEnabled);
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent,ConsolePluginProxyServiceConfig instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfigFluent<?> fluent,ConsolePluginProxyServiceConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsolePluginProxyServiceConfig());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfig instance) {
    this(instance,false);
  }
  public ConsolePluginProxyServiceConfigBuilder(ConsolePluginProxyServiceConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsolePluginProxyServiceConfig());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginProxyServiceConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginProxyServiceConfig build() {
    ConsolePluginProxyServiceConfig buildable = new ConsolePluginProxyServiceConfig(fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}